CREATE TABLE [dbo].[DIM_HOSPITAL_LOCATION_APPOINTMENT_ETL](
	[SOURCE_ID] [int] NOT NULL,
	[DOMAIN_ID] [nvarchar](50) NOT NULL,
	[FACILITY_UID] [nvarchar](250) NULL,
	[HOSPITAL_LOC_UID] [nvarchar](250) NULL,
	[VISTA_UID] [nvarchar](250) NULL,
	[_SSIS_TIMESTAMP] [datetime] NULL
) ON [PRIMARY]
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Update hospital location table used by reports incremental job.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DIM_HOSPITAL_LOCATION_APPOINTMENT_ETL'
GO
CREATE NONCLUSTERED INDEX [idx_DOMAIN_ID] ON [dbo].[DIM_HOSPITAL_LOCATION_APPOINTMENT_ETL] 
(
	[DOMAIN_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_FACILITY_UID] ON [dbo].[DIM_HOSPITAL_LOCATION_APPOINTMENT_ETL] 
(
	[FACILITY_UID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_HOSPITAL_LOCATION_UID] ON [dbo].[DIM_HOSPITAL_LOCATION_APPOINTMENT_ETL] 
(
	[HOSPITAL_LOC_UID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_SOURCE_ID] ON [dbo].[DIM_HOSPITAL_LOCATION_APPOINTMENT_ETL] 
(
	[SOURCE_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_VISTA_UID] ON [dbo].[DIM_HOSPITAL_LOCATION_APPOINTMENT_ETL] 
(
	[VISTA_UID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO



