CREATE TABLE [dbo].[DIM_ICON_FLAG_ETL](
	[GROUP] [nvarchar](100) NOT NULL,
	[SUBGROUP] [nvarchar](100) NOT NULL,
	[APP_ICONS_CODE] [varchar](100) NULL,
	[IMAGE_BYTES] [nvarchar](max) NOT NULL,
	[IMAGE_BYTES_INACTIVE] [nvarchar](max) NOT NULL,
	[ORDER_INDEX] [int] NOT NULL,
	[ACTIVE] [bit] NOT NULL,
	[PUBLISHED] [bit] NULL,
	[PATIENT_OR_ROOMBED] [char](1) NULL,
	[IMAGE_NAME] [nvarchar](250) NULL,
	[ICON_NAME] [nvarchar](150) NULL,
	[SHORT_DESCRIPTION] [nvarchar](150) NULL,
	[LONG_DESCRIPTION] [nvarchar](max) NULL,
	[COMMENT] [nvarchar](150) NULL,
	[MOUSE_OVER_TEXT] [nvarchar](150) NULL,
	[ENTERED_BY] [nvarchar](50) NULL,
	[ENTERED_DATE] [datetime] NULL,
	[LAST_EDIT_BY] [nvarchar](50) NULL,
	[LAST_EDIT_DATE] [datetime] NULL,
	[SOURCE_ID] [int] NOT NULL,
	[_SSIS_TIMESTAMP] [datetime] NULL
) ON [PRIMARY]
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Update icon flag table used by reports incremental job.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DIM_ICON_FLAG_ETL'
GO
CREATE NONCLUSTERED INDEX [idx_APP_ICONS_CODE] ON [dbo].[DIM_ICON_FLAG_ETL] 
(
	[APP_ICONS_CODE] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_SOURCE_ID] ON [dbo].[DIM_ICON_FLAG_ETL] 
(
	[SOURCE_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO


