
CREATE TABLE [dbo].[DIM_ICON_FLAG](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[GROUP] [nvarchar](100) NOT NULL,
	[SUBGROUP] [nvarchar](100) NOT NULL,
	[DIM_APPLICATION_ICONS_ID] [int] NULL,
	[IMAGE_BYTES] [nvarchar](max) NOT NULL,
	[IMAGE_BYTES_INACTIVE] [nvarchar](max) NOT NULL,
	[ORDER_INDEX] [int] NOT NULL,
	[ACTIVE] [bit] NOT NULL,
	[PUBLISHED] [bit] NULL,
	[PATIENT_OR_ROOMBED] [char](1) NULL,
	[IMAGE_NAME] [nvarchar](250) NULL,
	[ICON_NAME] [nvarchar](150) NULL,
	[SHORT_DESCRIPTION] [nvarchar](150) NULL,
	[LONG_DESCRIPTION] [nvarchar](max) NULL,
	[COMMENT] [nvarchar](150) NULL,
	[MOUSE_OVER_TEXT] [nvarchar](150) NULL,
	[ENTERED_BY] [nvarchar](50) NULL,
	[ENTERED_DATE] [datetime] NULL,
	[LAST_EDIT_BY] [nvarchar](50) NULL,
	[LAST_EDIT_DATE] [datetime] NULL,
	[SOURCE_ID] [nvarchar](250) NULL,
	[_SSIS_TIMESTAMP] [datetime] NULL,
 CONSTRAINT [PK_DIM_ICON_FLAG] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

SET ANSI_PADDING OFF
GO

ALTER TABLE [dbo].[DIM_ICON_FLAG]  WITH NOCHECK ADD  CONSTRAINT [FK_DIM_ICON_FLAG_DIM_APPLICATION_ICONS] FOREIGN KEY([DIM_APPLICATION_ICONS_ID])
REFERENCES [dbo].[DIM_APPLICATION_ICONS] ([ID])
GO

ALTER TABLE [dbo].[DIM_ICON_FLAG] CHECK CONSTRAINT [FK_DIM_ICON_FLAG_DIM_APPLICATION_ICONS]
GO

ALTER TABLE [dbo].[DIM_ICON_FLAG] ADD  CONSTRAINT [DF_DIM_ICON_FLAG_ENTERED_DATE]  DEFAULT (getutcdate()) FOR [ENTERED_DATE]
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identity primary key column.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DIM_ICON_FLAG', @level2type=N'COLUMN',@level2name=N'ID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The group or category the icon belongs to.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DIM_ICON_FLAG', @level2type=N'COLUMN',@level2name=N'GROUP'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The subgroup or subcategory the icon belongs to.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DIM_ICON_FLAG', @level2type=N'COLUMN',@level2name=N'SUBGROUP'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Id of the icon type.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DIM_ICON_FLAG', @level2type=N'COLUMN',@level2name=N'DIM_APPLICATION_ICONS_ID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The bytes array of the icon.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DIM_ICON_FLAG', @level2type=N'COLUMN',@level2name=N'IMAGE_BYTES'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The bytes array of the icon when it is inactive.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DIM_ICON_FLAG', @level2type=N'COLUMN',@level2name=N'IMAGE_BYTES_INACTIVE'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Order of the icons on the screen per subgroup.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DIM_ICON_FLAG', @level2type=N'COLUMN',@level2name=N'ORDER_INDEX'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'True/False flag for an active/inactive icon.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DIM_ICON_FLAG', @level2type=N'COLUMN',@level2name=N'ACTIVE'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The type of the icon.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DIM_ICON_FLAG', @level2type=N'COLUMN',@level2name=N'PATIENT_OR_ROOMBED'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The image name.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DIM_ICON_FLAG', @level2type=N'COLUMN',@level2name=N'IMAGE_NAME'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The icon name.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DIM_ICON_FLAG', @level2type=N'COLUMN',@level2name=N'ICON_NAME'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A short description of the icon.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DIM_ICON_FLAG', @level2type=N'COLUMN',@level2name=N'SHORT_DESCRIPTION'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A long description of the icon.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DIM_ICON_FLAG', @level2type=N'COLUMN',@level2name=N'LONG_DESCRIPTION'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A free text comment appropriate for the icon.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DIM_ICON_FLAG', @level2type=N'COLUMN',@level2name=N'COMMENT'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A free text to show on the top of the icon (hover text).' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DIM_ICON_FLAG', @level2type=N'COLUMN',@level2name=N'MOUSE_OVER_TEXT'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The user who inserted the icon.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DIM_ICON_FLAG', @level2type=N'COLUMN',@level2name=N'ENTERED_BY'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The icon inserted datetime.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DIM_ICON_FLAG', @level2type=N'COLUMN',@level2name=N'ENTERED_DATE'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The user who last edited the icon.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DIM_ICON_FLAG', @level2type=N'COLUMN',@level2name=N'LAST_EDIT_BY'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The date and time when the icon was last edited.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DIM_ICON_FLAG', @level2type=N'COLUMN',@level2name=N'LAST_EDIT_DATE'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Id of the record from BMS source table ICON_FLAG.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DIM_ICON_FLAG', @level2type=N'COLUMN',@level2name=N'SOURCE_ID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The date and time when the row has been inserted or modified.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DIM_ICON_FLAG', @level2type=N'COLUMN',@level2name=N'_ssis_timestamp'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Table that stores definitions of icons.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DIM_ICON_FLAG'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'True/False flag to express if the icon is published or not in BMS application.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DIM_ICON_FLAG', @level2type=N'COLUMN',@level2name=N'PUBLISHED'
GO

CREATE NONCLUSTERED INDEX [idx_SOURCE_ID] ON DIM_ICON_FLAG(SOURCE_ID ASC)
GO
CREATE NONCLUSTERED INDEX [idx_SUBGROUP] ON DIM_ICON_FLAG(SUBGROUP ASC)
GO