
CREATE TABLE [dbo].[FACT_DISCHARGE_REQ_ETL](
	[RELEASED_DATE] [datetime] NULL,
	[SIGNED_DATE] [datetime] NULL,
	[SIGNED_BY_UID] [nvarchar](250) NULL,
	[SCHEDULER_UID] [nvarchar](250) NULL,
	[PROVIDER_UID] [nvarchar](250) NULL,
	[VISTA_SITE_UID] [nvarchar](250) NULL,
	[HOSPITAL_LOCATION_UID] [nvarchar](250) NULL,
	[ORDER_TEXT] [nvarchar](max) NULL,
	[DIM_ORDERABLE_ITEM_CODE] [varchar](100) NULL,
	[DOMAIN_ID] [nvarchar](50) NOT NULL,
	[IEN] [varchar](50) NULL,
	[PATIENT_UID] [nvarchar](250) NULL,
	[ORDERED_DATE] [datetime] NOT NULL,
	[IS_ACTIVE] [bit] NOT NULL,
	[WARD_UID] [nvarchar](250) NULL,
	[CREATION_UTC_DATE] [datetime] NOT NULL,
	[_SSIS_TIMESTAMP] [datetime] NULL,
	[SOURCE_ID] [int] NOT NULL
) ON [PRIMARY]
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Contains all temporary discharge request information from bms database. Used by reports full job.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'FACT_DISCHARGE_REQ_ETL'
GO
CREATE NONCLUSTERED INDEX [idx_DIM_ORDERABLE_ITEM_CODE] ON [dbo].[FACT_DISCHARGE_REQ_ETL] 
(
	[DIM_ORDERABLE_ITEM_CODE] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_DOMAIN_ID] ON [dbo].[FACT_DISCHARGE_REQ_ETL] 
(
	[DOMAIN_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_HOSPITAL_LOCATION_UID] ON [dbo].[FACT_DISCHARGE_REQ_ETL] 
(
	[HOSPITAL_LOCATION_UID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_PATIENT_UID] ON [dbo].[FACT_DISCHARGE_REQ_ETL] 
(
	[PATIENT_UID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_PROVIDER_UID] ON [dbo].[FACT_DISCHARGE_REQ_ETL] 
(
	[PROVIDER_UID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_SCHEDULER_UID] ON [dbo].[FACT_DISCHARGE_REQ_ETL] 
(
	[SCHEDULER_UID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_SIGNED_BY_UID] ON [dbo].[FACT_DISCHARGE_REQ_ETL] 
(
	[SIGNED_BY_UID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_SOURCE_ID] ON [dbo].[FACT_DISCHARGE_REQ_ETL] 
(
	[SOURCE_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_VISTA_SITE_UID] ON [dbo].[FACT_DISCHARGE_REQ_ETL] 
(
	[VISTA_SITE_UID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_WARD_UID] ON [dbo].[FACT_DISCHARGE_REQ_ETL] 
(
	[WARD_UID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO