CREATE TABLE [dbo].[FACT_DISCHARGE_INT_ETL](
	[PATIENT_UID] [nvarchar](250) NULL,
	[DATE_ENTERED] [datetime] NOT NULL,
	[IS_ACTIVE] [bit] NOT NULL,
	[VISTA_SITE_UID] [nvarchar](250) NULL,
	[HOSPITAL_LOCATION_UID] [nvarchar](250) NULL,
	[WARD_UID] [nvarchar](250) NULL,
	[APPOINTMENT_DATE] [datetime] NULL,
	[STATUS] [nvarchar](max) NULL,
	[DOMAIN_ID] [nvarchar](50) NOT NULL,
	[CREATION_UTC_DATE] [datetime] NOT NULL,
	[SOURCE_ID] [int] NOT NULL,
	[_ssis_timestamp] [datetime] NULL
) ON [PRIMARY]
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Contains all temporary discharge intent information from bms database. Used by reports full job.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'FACT_DISCHARGE_INT_ETL'
GO
CREATE NONCLUSTERED INDEX [idx_PATIENT_UID] ON [dbo].[FACT_DISCHARGE_INT_ETL](PATIENT_UID ASC)
CREATE NONCLUSTERED INDEX [idx_WARD_UID] ON [dbo].[FACT_DISCHARGE_INT_ETL](WARD_UID ASC)
CREATE NONCLUSTERED INDEX [idx_VISTA_SITE_UID] ON [dbo].[FACT_DISCHARGE_INT_ETL](VISTA_SITE_UID ASC)
CREATE NONCLUSTERED INDEX [idx_DOMAIN_ID] ON [dbo].[FACT_DISCHARGE_INT_ETL](DOMAIN_ID ASC)
CREATE NONCLUSTERED INDEX [idx_HOSPITAL_LOCATION_UID] ON [dbo].[FACT_DISCHARGE_INT_ETL](HOSPITAL_LOCATION_UID ASC)
CREATE NONCLUSTERED INDEX [idx_SOURCE_ID] ON [dbo].[FACT_DISCHARGE_INT_ETL](SOURCE_ID ASC)