IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ufn_ETL_Dim_Icon_Flag]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION [dbo].[ufn_ETL_Dim_Icon_Flag]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE function [dbo].[ufn_ETL_Dim_Icon_Flag](@START_DATE DATETIME, @END_DATE DATETIME)
RETURNS TABLE 
AS
RETURN
(
	SELECT 
	   [GROUP]
      ,[SUBGROUP]
      ,bc.CODE as APP_ICONS_CODE
      ,[IMAGE_BYTES]
      ,[IMAGE_BYTES_INACTIVE]
      ,[ORDER_INDEX]
      ,[ACTIVE]
      ,[PUBLISHED]
      ,[PATIENT_OR_ROOMBED]
      ,[IMAGE_NAME]
      ,[ICON_NAME]
      ,[SHORT_DESCRIPTION]
      ,[LONG_DESCRIPTION]
      ,[COMMENT]
      ,[MOUSE_OVER_TEXT]
      ,[ENTERED_BY]
      ,[ENTERED_DATE]
      ,[LAST_EDIT_BY]
      ,[LAST_EDIT_DATE]
      ,BIF.[ID] as SOURCE_ID
      ,BIF.[_ssis_timestamp]
	
	FROM dbo.BMS_ICON_FLAG BIF LEFT JOIN [BMS_CONCEPT] bc ON bc.ID = BIF.[ICON_TYPE_ID]
	WHERE  BIF.[_isDeleted] = 0 AND BIF.[_ssis_timestamp] > @START_DATE
			AND BIF.[_ssis_timestamp] < @END_DATE
)
GO


