CREATE TABLE [dbo].[BED_REASON_COMMENT_HISTORY]
(
[ID] [int] NOT NULL IDENTITY(1, 1),
[DIVISION_UID] [uniqueidentifier] NULL,
[BED_UID] [uniqueidentifier] NOT NULL,
[VISTA_SITE_UID] [uniqueidentifier] NULL,
[TYPE_ID] [int] NULL,
[REASON_ID] [int] NULL,
[COMMENT] [nvarchar] (max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CREATIONBY] [nvarchar] (250) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CREATION_DATE] [datetime] NULL,
[EDITEDBY] [nvarchar] (250) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[EDITED_DATE] [datetime] NULL,
[EXPECTED_COMPLETED_DATE] [DATETIME] NULL,
[COMPLETEDBY] [nvarchar] (250) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[COMPLETED_DATE] [datetime] NULL,
[_ssis_timestamp] [datetime] NULL DEFAULT (getdate()),
[CREATEDBY] [nvarchar] (250) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CREATED] [datetime] NULL,
[UPDATEDBY] [nvarchar] (250) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UPDATED] [datetime] NULL
)
GO
-- Triggers

create trigger [dbo].[BED_REASON_COMMENT_HISTORY_tgg_ssis_delete] on dbo.BED_REASON_COMMENT_HISTORY after delete as begin  delete [dbo].[BED_REASON_COMMENT_HISTORY_ssisdel] from [deleted] _xyz where [dbo].[BED_REASON_COMMENT_HISTORY_ssisdel].[ID]=[_xyz].[ID];  insert into [dbo].[BED_REASON_COMMENT_HISTORY_ssisdel]([ID], _ssis_timestamp)  select [ID], current_timestamp from [deleted];  end
GO
create trigger [dbo].[BED_REASON_COMMENT_HISTORY_tgg_ssis_insert] on dbo.BED_REASON_COMMENT_HISTORY after insert as begin delete [dbo].[BED_REASON_COMMENT_HISTORY_ssisdel]  from [inserted] _xyz where [dbo].[BED_REASON_COMMENT_HISTORY_ssisdel].[ID]=[_xyz].[ID] end
GO
CREATE TRIGGER [dbo].[utg_BED_REASON_COMMENT_HISTORY_AfterDelete] 
   ON  [dbo].[BED_REASON_COMMENT_HISTORY] 
   AFTER DELETE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @HISTORY_VALUE NVARCHAR(50)

	SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'HISTORY';

    IF (UPPER(@HISTORY_VALUE) = 'Y')
     BEGIN 
		INSERT INTO $(varBMS_HISTORY).[dbo].[BED_REASON_COMMENT_HISTORY_H]
			   (BED_REASON_COMMENT_HISTORY_ID, COMMENT, DIVISION_UID, BED_UID, TYPE_ID, REASON_ID, TRANSACTION_TYPE_CODE, DATE, CREATED_BY,CREATION_BY, CREATION_DATE, EDITED_BY, EDITED_DATE,COMPLETED_BY,COMPLETED_DATE,
			   VISTA_SITE_UID, EXPECTED_COMPLETED_DATE)
			SELECT	ID,  COMMENT, DIVISION_UID, BED_UID, TYPE_ID, REASON_ID, 'D', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name(), CREATIONBY,  CREATION_DATE, EDITEDBY, EDITED_DATE,COMPLETEDBY,COMPLETED_DATE, VISTA_SITE_UID, EXPECTED_COMPLETED_DATE
			FROM deleted;
	 END		
END
GO
CREATE TRIGGER [dbo].[utg_BED_REASON_COMMENT_HISTORY_AfterInsert] 
   ON  [dbo].[BED_REASON_COMMENT_HISTORY] 
   AFTER INSERT
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @HISTORY_VALUE NVARCHAR(50)

    SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'HISTORY';

    IF (UPPER(@HISTORY_VALUE) = 'Y')
		INSERT INTO $(varBMS_HISTORY).[dbo].[BED_REASON_COMMENT_HISTORY_H]
			   (BED_REASON_COMMENT_HISTORY_ID, COMMENT,  DIVISION_UID, BED_UID, TYPE_ID, REASON_ID, TRANSACTION_TYPE_CODE, DATE, CREATED_BY, CREATION_BY,  CREATION_DATE, EDITED_BY, EDITED_DATE,COMPLETED_BY,COMPLETED_DATE,
			   VISTA_SITE_UID, EXPECTED_COMPLETED_DATE)
			SELECT ID, COMMENT, DIVISION_UID, BED_UID, TYPE_ID, REASON_ID, 'I', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name(),  CREATIONBY,  CREATION_DATE, EDITEDBY, EDITED_DATE,COMPLETEDBY,COMPLETED_DATE, VISTA_SITE_UID, EXPECTED_COMPLETED_DATE
			FROM inserted;


END
GO
CREATE TRIGGER [dbo].[utg_BED_REASON_COMMENT_HISTORY_AfterUpdate] 
   ON  [dbo].[BED_REASON_COMMENT_HISTORY] 
   AFTER UPDATE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @HISTORY_VALUE NVARCHAR(50)

    SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'HISTORY';

	IF (UPPER(@HISTORY_VALUE) = 'Y')
	   INSERT INTO $(varBMS_HISTORY).[dbo].[BED_REASON_COMMENT_HISTORY_H]
			    (BED_REASON_COMMENT_HISTORY_ID, COMMENT, DIVISION_UID, BED_UID, TYPE_ID, REASON_ID, TRANSACTION_TYPE_CODE, DATE, CREATED_BY,  CREATION_BY, CREATION_DATE, EDITED_BY, EDITED_DATE,COMPLETED_BY,COMPLETED_DATE,
			   VISTA_SITE_UID, EXPECTED_COMPLETED_DATE)
			SELECT ID, COMMENT, DIVISION_UID, BED_UID, TYPE_ID, REASON_ID, 'U', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name(),  CREATIONBY, CREATION_DATE,EDITEDBY, EDITED_DATE,COMPLETEDBY,COMPLETED_DATE, VISTA_SITE_UID, EXPECTED_COMPLETED_DATE
			FROM inserted;

END
GO
CREATE TRIGGER [dbo].[utg_BED_REASON_COMMENT_HISTORY_InsteadOfInsert] 
   ON  [dbo].[BED_REASON_COMMENT_HISTORY]
   INSTEAD OF INSERT
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
    DECLARE @AUDIT_VALUE NVARCHAR(50)

    SELECT @AUDIT_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'AUDIT';

    IF (UPPER(@AUDIT_VALUE) = 'Y')
     BEGIN
		INSERT INTO [dbo].[BED_REASON_COMMENT_HISTORY]
			   (COMMENT, DIVISION_UID, BED_UID, TYPE_ID, REASON_ID, _ssis_timestamp, CREATED, CREATEDBY,  CREATIONBY, CREATION_DATE, EDITEDBY, EDITED_DATE,COMPLETEDBY,COMPLETED_DATE, 
				VISTA_SITE_UID, EXPECTED_COMPLETED_DATE)
			SELECT COMMENT, DIVISION_UID, BED_UID, TYPE_ID, REASON_ID, _ssis_timestamp, GETUTCDATE(), dbo.ufn_Get_BMS_User_Name(),  CREATIONBY, CREATION_DATE, EDITEDBY, EDITED_DATE,COMPLETEDBY,	COMPLETED_DATE, VISTA_SITE_UID, EXPECTED_COMPLETED_DATE
			  FROM inserted;

	  END
	ELSE
		INSERT INTO [dbo].[BED_REASON_COMMENT_HISTORY]
			    ( COMMENT,  DIVISION_UID, BED_UID, TYPE_ID, REASON_ID, _ssis_timestamp,  CREATIONBY, CREATION_DATE, EDITEDBY, EDITED_DATE,COMPLETEDBY,COMPLETED_DATE, VISTA_SITE_UID, EXPECTED_COMPLETED_DATE)
			SELECT COMMENT, DIVISION_UID, BED_UID, TYPE_ID, REASON_ID, _ssis_timestamp,  CREATIONBY, CREATION_DATE, EDITEDBY, EDITED_DATE,COMPLETEDBY,COMPLETED_DATE, VISTA_SITE_UID, EXPECTED_COMPLETED_DATE
			  FROM inserted;

END
GO
CREATE TRIGGER [dbo].[utg_BED_REASON_COMMENT_HISTORY_InsteadOfUpdate] 
   ON  [dbo].[BED_REASON_COMMENT_HISTORY] 
   INSTEAD OF UPDATE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @AUDIT_VALUE NVARCHAR(50)

    SELECT @AUDIT_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE UPPER(PARAMETER) = 'AUDIT';

    IF (UPPER(@AUDIT_VALUE) = 'Y')
	 	UPDATE [dbo].[BED_REASON_COMMENT_HISTORY]
		SET  DIVISION_UID = inserted.DIVISION_UID,
		    COMMENT  = inserted.COMMENT, 
			BED_UID = inserted.BED_UID,			
			TYPE_ID = inserted.TYPE_ID,
			REASON_ID = inserted.REASON_ID,
			_ssis_timestamp = current_timestamp,
			UPDATEDBY = dbo.ufn_Get_BMS_User_Name(),
			UPDATED = GETUTCDATE(),
		    CREATIONBY = inserted.CREATIONBY,
		    CREATION_DATE= inserted.CREATION_DATE, 
		    EDITEDBY =  inserted.EDITEDBY ,
		    EDITED_DATE =  inserted.EDITED_DATE, 
		    COMPLETEDBY =  inserted.COMPLETEDBY,
		    COMPLETED_DATE	=  inserted.COMPLETED_DATE,
		    VISTA_SITE_UID = inserted.VISTA_SITE_UID,
		    EXPECTED_COMPLETED_DATE = inserted.EXPECTED_COMPLETED_DATE
		FROM [dbo].[BED_REASON_COMMENT_HISTORY]
		INNER JOIN inserted ON inserted.ID = [dbo].[BED_REASON_COMMENT_HISTORY].ID;

	 ELSE
	    UPDATE [dbo].[BED_REASON_COMMENT_HISTORY]
		SET  DIVISION_UID = inserted.DIVISION_UID,
		    COMMENT  = inserted.COMMENT, 
			BED_UID = inserted.BED_UID,
			TYPE_ID = inserted.TYPE_ID,
			REASON_ID = inserted.REASON_ID,
			_ssis_timestamp = current_timestamp,
			CREATIONBY = inserted.CREATIONBY, 
			CREATION_DATE= inserted.CREATION_DATE, 
		    EDITEDBY =  inserted.EDITEDBY ,
		    EDITED_DATE =  inserted.EDITED_DATE, 
		    COMPLETEDBY =  inserted.COMPLETEDBY,
		    COMPLETED_DATE	=  inserted.COMPLETED_DATE,
		    VISTA_SITE_UID = inserted.VISTA_SITE_UID,
		    EXPECTED_COMPLETED_DATE = inserted.EXPECTED_COMPLETED_DATE
		FROM [dbo].[BED_REASON_COMMENT_HISTORY]
		INNER JOIN inserted ON inserted.ID = [dbo].[BED_REASON_COMMENT_HISTORY].ID;

END
GO

-- Constraints
ALTER TABLE [dbo].[BED_REASON_COMMENT_HISTORY] ADD CONSTRAINT [PK_BED_REASON_COMMENT_HISTORY] PRIMARY KEY CLUSTERED  ([ID])
GO
ALTER TABLE [dbo].[BED_REASON_COMMENT_HISTORY] ADD CONSTRAINT [FK_BED_REASON_COMMENT_HISTORY_CONCEPT_REASON] FOREIGN KEY ([REASON_ID]) REFERENCES [dbo].[CONCEPT] ([ID])
GO
ALTER TABLE [dbo].[BED_REASON_COMMENT_HISTORY] ADD CONSTRAINT [FK_BED_REASON_COMMENT_HISTORY_CONCEPT_TYPE] FOREIGN KEY ([TYPE_ID]) REFERENCES [dbo].[CONCEPT] ([ID])
GO


--Indexes
CREATE NONCLUSTERED INDEX [IDX_BED_DIVISION] ON [dbo].[BED_REASON_COMMENT_HISTORY] 
(
	[BED_UID] ASC,
	[DIVISION_UID] ASC
)
INCLUDE ( [COMMENT]) WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO

CREATE NONCLUSTERED INDEX [IDX_SSIS_MODIFY] ON [dbo].[BED_REASON_COMMENT_HISTORY] 
(
	[_ssis_timestamp] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO

-- Extended Properties
EXEC sp_addextendedproperty N'MS_Description', N'Bed unavailable table.', 'SCHEMA', N'dbo', 'TABLE', N'BED_REASON_COMMENT_HISTORY', NULL, NULL
GO
EXEC sp_addextendedproperty N'MS_Description', N'PRIMARY KEY.', 'SCHEMA', N'dbo', 'TABLE', N'BED_REASON_COMMENT_HISTORY', 'COLUMN', N'ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The date and time when the row has been inserted or modified.', 'SCHEMA', N'dbo', 'TABLE', N'BED_REASON_COMMENT_HISTORY', 'COLUMN', N'_ssis_timestamp'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Beds''id.', 'SCHEMA', N'dbo', 'TABLE', N'BED_REASON_COMMENT_HISTORY', 'COLUMN', N'BED_UID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Datetime when a BMS user completed an unvailable reason for bed.', 'SCHEMA', N'dbo', 'TABLE', N'BED_REASON_COMMENT_HISTORY', 'COLUMN', N'COMPLETED_DATE'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The name of the user who completed an unvailable reason for bed.', 'SCHEMA', N'dbo', 'TABLE', N'BED_REASON_COMMENT_HISTORY', 'COLUMN', N'COMPLETEDBY'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Datetime when record was created.', 'SCHEMA', N'dbo', 'TABLE', N'BED_REASON_COMMENT_HISTORY', 'COLUMN', N'CREATED'
GO
EXEC sp_addextendedproperty N'MS_Description', N'User ID of user when record was created.', 'SCHEMA', N'dbo', 'TABLE', N'BED_REASON_COMMENT_HISTORY', 'COLUMN', N'CREATEDBY'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The name of the user who created an unvailable reason for bed.', 'SCHEMA', N'dbo', 'TABLE', N'BED_REASON_COMMENT_HISTORY', 'COLUMN', N'CREATIONBY'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Ward''s id.', 'SCHEMA', N'dbo', 'TABLE', N'BED_REASON_COMMENT_HISTORY', 'COLUMN', N'DIVISION_UID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Date time when a bms user created an unvailable reason for bed.', 'SCHEMA', N'dbo', 'TABLE', N'BED_REASON_COMMENT_HISTORY', 'COLUMN', N'CREATION_DATE'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Datetime when a BMS user updated an unvailable reason for bed.', 'SCHEMA', N'dbo', 'TABLE', N'BED_REASON_COMMENT_HISTORY', 'COLUMN', N'EDITED_DATE'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The name of the user who updated an unvailable reason for bed.', 'SCHEMA', N'dbo', 'TABLE', N'BED_REASON_COMMENT_HISTORY', 'COLUMN', N'EDITEDBY'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The reason for which the bed is unavailable.', 'SCHEMA', N'dbo', 'TABLE', N'BED_REASON_COMMENT_HISTORY', 'COLUMN', N'REASON_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Type column (concept).', 'SCHEMA', N'dbo', 'TABLE', N'BED_REASON_COMMENT_HISTORY', 'COLUMN', N'TYPE_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Datetime when record was changed(updated).', 'SCHEMA', N'dbo', 'TABLE', N'BED_REASON_COMMENT_HISTORY', 'COLUMN', N'UPDATED'
GO
EXEC sp_addextendedproperty N'MS_Description', N'User ID of user when record was updated.', 'SCHEMA', N'dbo', 'TABLE', N'BED_REASON_COMMENT_HISTORY', 'COLUMN', N'UPDATEDBY'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Id of the facility where the bed is located.', 'SCHEMA', N'dbo', 'TABLE', N'BED_REASON_COMMENT_HISTORY', 'COLUMN', N'VISTA_SITE_UID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Comments column.', 'SCHEMA', N'dbo', 'TABLE', N'BED_REASON_COMMENT_HISTORY', 'COLUMN', N'COMMENT'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The time/date expected out of service ends for the bed', 'SCHEMA', N'dbo', 'TABLE', N'BED_REASON_COMMENT_HISTORY', 'COLUMN', N'EXPECTED_COMPLETED_DATE'
GO

