-- Columns

CREATE TABLE [dbo].[BED_UNAVAILABLE_WARD]
(
[ID] [int] NOT NULL IDENTITY(1, 1),
[BED_UNAVAILABLE_ID] [int] NOT NULL,
[WARD_UID] [uniqueidentifier] NOT NULL,
[_ssis_timestamp] [datetime] NULL CONSTRAINT [DF_BED_UNAVAILABLE_WARD__ssis_timestamp] DEFAULT (getdate()),
[CREATEDBY] [nvarchar](50) NULL,
[CREATED] [datetime] NULL,
[UPDATEDBY] [nvarchar](50) NULL,
[UPDATED] [datetime] NULL,
)
GO
-- Triggers

CREATE trigger [dbo].[BED_UNAVAILABLE_WARD_tgg_ssis_delete] on dbo.BED_UNAVAILABLE_WARD after delete as begin  delete [dbo].[BED_UNAVAILABLE_WARD_ssisdel] from [deleted] _xyz where [dbo].[BED_UNAVAILABLE_WARD_ssisdel].[ID]=[_xyz].[ID];  insert into [dbo].[BED_UNAVAILABLE_WARD_ssisdel]([ID], _ssis_timestamp)  select [ID], current_timestamp from [deleted];  end
GO
CREATE trigger [dbo].[BED_UNAVAILABLE_WARD_tgg_ssis_insert] on dbo.BED_UNAVAILABLE_WARD after insert as begin delete [dbo].[BED_UNAVAILABLE_WARD_ssisdel]  from [inserted] _xyz where [dbo].[BED_UNAVAILABLE_WARD_ssisdel].[ID]=[_xyz].[ID] end
GO
CREATE TRIGGER [dbo].[utg_Bed_Unavailable_Ward_AfterDelete] 
   ON  [dbo].[BED_UNAVAILABLE_WARD] 
   AFTER DELETE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @HISTORY_VALUE NVARCHAR(50)

	SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'HISTORY';

    IF (UPPER(@HISTORY_VALUE) = 'Y')
     BEGIN 
		INSERT INTO $(varBMS_HISTORY).[dbo].[Bed_Unavailable_Ward_H]
			   (ID, BED_UNAVAILABLE_ID, WARD_UID, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
			SELECT	ID, BED_UNAVAILABLE_ID, WARD_UID, 'D', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			FROM deleted;
	 END		
END
GO
CREATE TRIGGER [dbo].[utg_Bed_Unavailable_Ward_AfterInsert] 
   ON  [dbo].[BED_UNAVAILABLE_WARD] 
   AFTER INSERT
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @HISTORY_VALUE NVARCHAR(50)

    SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'HISTORY';

    IF (UPPER(@HISTORY_VALUE) = 'Y')
		INSERT INTO $(varBMS_HISTORY).[dbo].[Bed_Unavailable_Ward_H]
			   (ID, BED_UNAVAILABLE_ID, WARD_UID, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
			SELECT ID, BED_UNAVAILABLE_ID, WARD_UID, 'I', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			FROM inserted;


END
GO
CREATE TRIGGER [dbo].[utg_Bed_Unavailable_Ward_AfterUpdate] 
   ON  [dbo].[BED_UNAVAILABLE_WARD] 
   AFTER UPDATE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @HISTORY_VALUE NVARCHAR(50)

    SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'HISTORY';

	IF (UPPER(@HISTORY_VALUE) = 'Y')
	   INSERT INTO $(varBMS_HISTORY).[dbo].[Bed_Unavailable_Ward_H]
			   (ID, BED_UNAVAILABLE_ID, WARD_UID, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
			SELECT ID, BED_UNAVAILABLE_ID, WARD_UID, 'U', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			FROM inserted;

END
GO
CREATE TRIGGER [dbo].[utg_Bed_Unavailable_Ward_InsteadOfInsert] 
   ON  [dbo].[BED_UNAVAILABLE_WARD]
   INSTEAD OF INSERT
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
    DECLARE @AUDIT_VALUE NVARCHAR(50)

    SELECT @AUDIT_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'AUDIT';

    IF (UPPER(@AUDIT_VALUE) = 'Y')
     BEGIN
		INSERT INTO [dbo].[Bed_Unavailable_Ward]
			   (BED_UNAVAILABLE_ID, WARD_UID, _ssis_timestamp, CREATED, CREATEDBY)
			SELECT BED_UNAVAILABLE_ID, WARD_UID, _ssis_timestamp, GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			  FROM inserted;

	  END
	ELSE
		INSERT INTO [dbo].[Bed_Unavailable_Ward]
			   (BED_UNAVAILABLE_ID, WARD_UID, _ssis_timestamp)
			SELECT BED_UNAVAILABLE_ID, WARD_UID, _ssis_timestamp
			  FROM inserted;

END
GO

CREATE TRIGGER [dbo].[utg_Bed_Unavailable_Ward_InsteadOfUpdate] 
   ON  [dbo].[BED_UNAVAILABLE_WARD] 
   INSTEAD OF UPDATE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @AUDIT_VALUE NVARCHAR(50)

    SELECT @AUDIT_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE UPPER(PARAMETER) = 'AUDIT';

    IF (UPPER(@AUDIT_VALUE) = 'Y')
 		UPDATE [dbo].[Bed_Unavailable_Ward]
		SET BED_UNAVAILABLE_ID = inserted.BED_UNAVAILABLE_ID, 
			WARD_UID = inserted.WARD_UID,			
			_ssis_timestamp = current_timestamp,
			UPDATEDBY = dbo.ufn_Get_BMS_User_Name(),
			UPDATED = GETUTCDATE()
		FROM [dbo].[Bed_Unavailable_Ward]
		INNER JOIN inserted ON inserted.id = [dbo].[Bed_Unavailable_Ward].id;
	ELSE
		UPDATE [dbo].[Bed_Unavailable_Ward]
		SET BED_UNAVAILABLE_ID = inserted.BED_UNAVAILABLE_ID, 
			WARD_UID = inserted.WARD_UID,			
			_ssis_timestamp = current_timestamp
		FROM [dbo].[Bed_Unavailable_Ward]
		INNER JOIN inserted ON inserted.id = [dbo].[Bed_Unavailable_Ward].id;	

END
GO

-- Constraints
ALTER TABLE [dbo].[BED_UNAVAILABLE_WARD] ADD CONSTRAINT [PK_BED_UNAVAILABLE_WARD] PRIMARY KEY CLUSTERED  ([ID])
GO
ALTER TABLE [dbo].[BED_UNAVAILABLE_WARD] ADD CONSTRAINT [FK_BED_UNAVAILABLE_WARD_BED_UNAVAILABLE] FOREIGN KEY ([BED_UNAVAILABLE_ID]) REFERENCES [dbo].[BED_UNAVAILABLE] ([ACT_ID])
GO

--Indexes
CREATE NONCLUSTERED INDEX [IDX_BED_WARD] ON [dbo].[BED_UNAVAILABLE_WARD] 
(
	[BED_UNAVAILABLE_ID] ASC,
	[WARD_UID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO

CREATE NONCLUSTERED INDEX [IDX_WARD_UID] ON [dbo].[BED_UNAVAILABLE_WARD] 
(
	[WARD_UID] ASC
)
INCLUDE([BED_UNAVAILABLE_ID])
WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO

-- Extended properties
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identity integer primary key.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'BED_UNAVAILABLE_WARD', @level2type=N'COLUMN',@level2name=N'ID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Id of the bed unavailable act.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'BED_UNAVAILABLE_WARD', @level2type=N'COLUMN',@level2name=N'BED_UNAVAILABLE_ID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Id of the ward.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'BED_UNAVAILABLE_WARD', @level2type=N'COLUMN',@level2name=N'WARD_UID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The date and time when the row has been inserted or modified.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'BED_UNAVAILABLE_WARD', @level2type=N'COLUMN',@level2name=N'_ssis_timestamp'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Table that associates a bed unavailable and a ward.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'BED_UNAVAILABLE_WARD'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The User ID of the user who created the record.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'BED_UNAVAILABLE_WARD', @level2type=N'COLUMN',@level2name=N'CREATEDBY'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The date and time when the record was created.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'BED_UNAVAILABLE_WARD', @level2type=N'COLUMN',@level2name=N'CREATED'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The User ID of the user who updated the record.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'BED_UNAVAILABLE_WARD', @level2type=N'COLUMN',@level2name=N'UPDATEDBY'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The date and time when the record was edited.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'BED_UNAVAILABLE_WARD', @level2type=N'COLUMN',@level2name=N'UPDATED'
GO