﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.Facade.Data;
using BMS.Schedulers;
using BMS.Schedulers.Managers;
using BMS.ServicesWrapper.Security;
using BMS.Facade;

namespace BMS.WhiteboardReport
{
    public class WhiteboardReportManager
    {
        private static WhiteboardReportManager instance = new WhiteboardReportManager();
        private bool isStarted = false;

        public static WhiteboardReportManager Instance
        {
            get { return instance; }
        }        

        public void Start()
        {
            if (isStarted)
                throw new InvalidOperationException();
            isStarted = true;
            RefreshCommands();
        }

        public void Stop()
        {
            if (!isStarted) return;
            isStarted = false;
            SchedulerManager.Instance.RemoveCommands<WhiteboardReportCommand>();
        }

        public void RefreshCommands()
        {
            string domain = SecurityFactory.InstanceWindows.GetCurrentDomain();
            List<WhiteboardReportConfigEntry> wReportEntries = FacadeManager.ConfigurationInterface.GetWhiteboardReportEntries(domain);
            Dictionary<string, WhiteboardReportCommand> commands = wReportEntries.ToDictionary(a => a.Calendar.Id, a => new WhiteboardReportCommand(a.Facilities));
            SchedulerManager.Instance.SetCommands(commands);
        }
    }
}
