﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using BMS.Facade.Data;
using InfoWorld.HL7.ITS;
using BMS.Web.App_GlobalResource;
using System.ComponentModel.DataAnnotations;
using BMS.Utils;
using BMS.Web.Controllers.Shared;

namespace BMS.Web.Models
{
    public class TransferViewModel : BaseViewModel
    {
        /// <summary>
        /// Gets or sets the message.
        /// </summary>
        /// <value>
        /// The message.
        /// </value>
        public string Message { get; set; }

        /// <summary>
        /// Gets or sets the display facility message.
        /// </summary>
        /// <value>
        /// The display facility message.
        /// </value>
        public string DisplayFacilityMessage { get; set; }

        /// <summary>
        /// Gets or sets the display SSN message.
        /// </summary>
        /// <value>
        /// The display SSN message.
        /// </value>
        public string DisplaySSNMessage { get; set; }

        /// <summary>
        /// Gets or sets the facility id parameter.
        /// </summary>
        /// <value>
        /// The facility id param.
        /// </value>
        public string FacilityIdParam { get; set; }

        /// <summary>
        /// Gets or sets the visn.
        /// </summary>
        /// <value>
        /// The visn.
        /// </value>
        public Visn Visn { get; set; }

        /// <summary>
        /// Gets or sets the visn extension.
        /// </summary>
        /// <value>
        /// The visn extension.
        /// </value>
        public string VisnExtension { get; set; }

        /// <summary>
        /// Gets or sets the visn root.
        /// </summary>
        /// <value>
        /// The visn root.
        /// </value>
        public string VisnRoot { get; set; }

        /// <summary>
        /// Gets or sets the region.
        /// </summary>
        /// <value>
        /// The region.
        /// </value>
        public string Region { get; set; }

        /// <summary>
        /// Gets or sets the extension facility id.
        /// </summary>
        /// <value>
        /// The extension facility id.
        /// </value>
        public string ExtensionFacilityId { get; set; }

        /// <summary>
        /// Gets or sets the root facility id.
        /// </summary>
        /// <value>
        /// The root facility id.
        /// </value>
        public string RootFacilityId { get; set; }

        /// <summary>
        /// Gets or sets the extension patient id.
        /// </summary>
        /// <value>
        /// The extension patient id.
        /// </value>
        public string ExtensionPatientId { get; set; }

        /// <summary>
        /// Gets or sets the root patient id.
        /// </summary>
        /// <value>
        /// The root patient id.
        /// </value>
        public string RootPatientId { get; set; }

        /// <summary>
        /// Gets or sets the name of the facility.
        /// </summary>
        /// <value>
        /// The name of the facility.
        /// </value>
        public string FacilityName { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is add transfer.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if this instance is add transfer; otherwise, <c>false</c>.
        /// </value>
        public bool IsAddTransfer { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is valid finalize tranfer.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if this instance is valid finalize tranfer; otherwise, <c>false</c>.
        /// </value>
        public bool IsValidFinalizeTranfer { get; set; }

        /// <summary>
        /// Gets or sets the name of the selected facility.
        /// </summary>
        /// <value>
        /// The name of the selected facility.
        /// </value>
        public string SelectedFacilityName { get; set; }

        /// <summary>
        /// Gets or sets the facility list.
        /// </summary>
        /// <value>
        /// The facility list.
        /// </value>
        public IList<Facility> FacilityList { get; set; }

        /// <summary>
        /// Gets or sets the name of the patient.
        /// </summary>
        /// <value>
        /// The name of the patient.
        /// </value>
        [Required(ErrorMessage = "The Patient Name field is required.")]
        [RegularExpression(@"([A-Za-z]+),\s([A-Za-z]+)(\s([A-Za-z])){0,1}", ErrorMessage = "The correct format is LastName, FirstName InitialOfMiddleName")]
        [ValidateXss]
        public string PatientName { get; set; }

        /// <summary>
        /// Gets or sets the patient SSN.
        /// </summary>
        /// <value>
        /// The patient SSN.
        /// </value>
        public string PatientSSN { get; set; }

        /// <summary>
        /// Gets or sets the patient gender.
        /// </summary>
        /// <value>
        /// The patient gender.
        /// </value>
        public string PatientGender { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is vista validated.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if this instance is vista validated; otherwise, <c>false</c>.
        /// </value>
        public bool IsVistaValidated { get; set; }

        /// <summary>
        /// Gets or sets the SC rating.
        /// </summary>
        /// <value>
        /// The SC rating.
        /// </value>
        [RegularExpression("([0-9]+)", ErrorMessage = "The SERVICE CONNECTED PERCENTAGE must be a number between 0 and 100.")]
        [Range(0, 100, ErrorMessage = "The SERVICE CONNECTED PERCENTAGE must be a number between 0 and 100.")]
        public string SCRating { get; set; }

        /// <summary>
        /// Gets or sets the selected contract code.
        /// </summary>
        /// <value>
        /// The selected contract code.
        /// </value>
        public string SelectedContractCode { get; set; }

        /// <summary>
        /// Gets or sets the name of the selected contract.
        /// </summary>
        /// <value>
        /// The name of the selected contract.
        /// </value>
        public string SelectedContractName { get; set; }
        /// <summary>
        /// Gets or sets the selected era code.
        /// </summary>
        /// <value>
        /// The selected era code.
        /// </value>
        public string SelectedEraCode { get; set; }

        /// <summary>
        /// Gets or sets the name of the selected era.
        /// </summary>
        /// <value>
        /// The name of the selected era.
        /// </value>
        public string SelectedEraName { get; set; }

        /// <summary>
        /// Gets or sets the selected speciality code.
        /// </summary>
        /// <value>
        /// The selected speciality code.
        /// </value>
        public string SelectedSpecialityCode { get; set; }

        /// <summary>
        /// Gets or sets the name of the selected specialty.
        /// </summary>
        /// <value>
        /// The name of the selected specialty.
        /// </value>
        public string SelectedSpecialtyName { get; set; }

        /// <summary>
        /// Gets or sets the contract list.
        /// </summary>
        /// <value>
        /// The contract list.
        /// </value>
        public CDList ContractList { get; set; }

        /// <summary>
        /// Gets or sets the era list.
        /// </summary>
        /// <value>
        /// The era list.
        /// </value>
        public CDList EraList { get; set; }

        /// <summary>
        /// Gets or sets the speciality list.
        /// </summary>
        /// <value>
        /// The speciality list.
        /// </value>
        public List<CD> SpecialityList { get; set; }

        /// <summary>
        /// Gets or sets the diagnosis.
        /// </summary>
        /// <value>
        /// The diagnosis.
        /// </value>
        [ValidateXss]
        public string Diagnosis { get; set; }

        /// <summary>
        /// Gets or sets the current location.
        /// </summary>
        /// <value>
        /// The current location.
        /// </value>
        [ValidateXss]
        public string CurrentLocation { get; set; }

        /// <summary>
        /// Gets or sets the location admission date.
        /// </summary>
        /// <value>
        /// The location admission date.
        /// </value>
        public DateTime? LocationAdmissionDate { get; set; }
        public string SelectedLocationAdmissionDate
        {
            get { return (LocationAdmissionDate.HasValue) ? LocationAdmissionDate.Value.ToString(Strings.USDate) : string.Empty; }
            set
            {
                DateTime entryInLogMethodTime = DateTime.UtcNow;
                if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
                }
                try
                {
                    try
                    {
                        LocationAdmissionDate = DateTime.Parse(value);
                    }
                    catch
                    {
                        LocationAdmissionDate = null;
                    }
                }
                finally
                {
                    if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                    {
                        InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                    }
                }
            }
        }

        /// <summary>
        /// Gets or sets the comments.
        /// </summary>
        /// <value>
        /// The comments.
        /// </value>
        [StringLength(Constants.COMMENTS_MAX_LENGTH, ErrorMessageResourceType = typeof(Strings), ErrorMessageResourceName = "CommentsTypeNeedLengthError")]
        [ValidateXss]
        public string Comments { get; set; }

        /// <summary>
        /// Gets or sets the selected disposition code.
        /// </summary>
        /// <value>
        /// The selected disposition code.
        /// </value>
        public string SelectedDispositionCode { get; set; }

        /// <summary>
        /// Gets or sets the name of the selected disposition.
        /// </summary>
        /// <value>
        /// The name of the selected disposition.
        /// </value>
        public string SelectedDispositionName { get; set; }

        /// <summary>
        /// Gets or sets the disposition list.
        /// </summary>
        /// <value>
        /// The disposition list.
        /// </value>
        public CDList DispositionList { get; set; }

        /// <summary>
        /// Gets or sets the selected admission facility id.
        /// </summary>
        /// <value>
        /// The selected admission facility id.
        /// </value>
        public string SelectedAdmissionFacilityId { get; set; }

        /// <summary>
        /// Gets or sets the name of the selected admission facility.
        /// </summary>
        /// <value>
        /// The name of the selected admission facility.
        /// </value>
        public string SelectedAdmissionFacilityName { get; set; }

        /// <summary>
        /// Gets or sets the name of the selected gender.
        /// </summary>
        /// <value>
        /// The name of the selected gender.
        /// </value>
        public string SelectedGenderName { get; set; }

        /// <summary>
        /// Gets or sets the disposition date.
        /// </summary>
        /// <value>
        /// The disposition date.
        /// </value>
        public DateTime? DispositionDate { get; set; }
        public string SelectedDispositionDate
        {

            get { return (DispositionDate.HasValue) ? DispositionDate.Value.ToString(Strings.USDate) : string.Empty; }
            set
            {
                DateTime entryInLogMethodTime = DateTime.UtcNow;
                if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
                }
                try
                {
                    try
                    {
                        DispositionDate = DateTime.Parse(value);
                    }
                    catch
                    {
                        DispositionDate = null;
                    }
                }
                finally
                {
                    if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                    {
                        InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                    }
                }
            }
        }

        /// <summary>
        /// Gets or sets the requested date.
        /// </summary>
        /// <value>
        /// The requested date.
        /// </value>
        public DateTime? RequestedDate { get; set; }
        public string SelectedRequestedDate
        {
            get { return (RequestedDate.HasValue) ? RequestedDate.Value.ToString(Strings.USDate) : string.Empty; }
            set
            {
                DateTime entryInLogMethodTime = DateTime.UtcNow;
                if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
                }
                try
                {
                    try
                    {
                        RequestedDate = DateTime.Parse(value);
                    }
                    catch
                    {
                        RequestedDate = null;
                    }
                }
                finally
                {
                    if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                    {
                        InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                    }
                }
            }
        }

        /// <summary>
        /// Gets or sets the discharge comment.
        /// </summary>
        /// <value>
        /// The discharge comment.
        /// </value>
        [StringLength(Constants.COMMENTS_MAX_LENGTH, ErrorMessageResourceType = typeof(Strings), ErrorMessageResourceName = "DischargeCommentLengthError")]
        [ValidateXss]
        public string DischargeComment { get; set; }

        /// <summary>
        /// Gets or sets the record number.
        /// </summary>
        /// <value>
        /// The record number.
        /// </value>
        public string RecordNumber { get; set; }

        /// <summary>
        /// Gets or sets the request date time.
        /// </summary>
        /// <value>
        /// The request date time.
        /// </value>
        public string RequestDateTime { get; set; }

        /// <summary>
        /// Gets or sets the transfer request id.
        /// </summary>
        /// <value>
        /// The transfer request id.
        /// </value>
        public II TransferRequestId { get; set; }

        /// <summary>
        /// Gets or sets the transfer request id root.
        /// </summary>
        /// <value>
        /// The transfer request id root.
        /// </value>
        public string TransferRequestIdRoot { get; set; }

        /// <summary>
        /// Gets or sets the transfer request id extension.
        /// </summary>
        /// <value>
        /// The transfer request id extension.
        /// </value>
        public string TransferRequestIdExtension { get; set; }

        /// <summary>
        /// Gets or sets the style disabled.
        /// </summary>
        /// <value>
        /// The style disabled.
        /// </value>
        public string StyleDisabled { get; set; }

        /// <summary>
        /// Gets or sets the gender list.
        /// </summary>
        /// <value>
        /// The gender list.
        /// </value>
        public CDList GenderList { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is national wait list.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if this instance is national wait list; otherwise, <c>false</c>.
        /// </value>
        public bool IsNationalWaitList { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is go back home page.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if this instance is go back home page; otherwise, <c>false</c>.
        /// </value>
        public bool IsGoBackHomePage { get; set; }

        /// <summary>
        /// Gets or sets the button cancel.
        /// </summary>
        /// <value>
        /// The button cancel.
        /// </value>
        public string ButtonCancel { get; set; }
    }
}
