﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace BMS.Web.Models
{
    /// <summary>
    /// Model for Clear All view on BedInformation controller.
    /// </summary>
    public class BedInfoClearAllCommentsViewModel : BaseViewModel
    {

        /// <summary>
        /// Gets or sets the bed.
        /// </summary>
        /// <value>
        /// The bed.
        /// </value>
        public string BedName { get; set; }
        /// <summary>
        /// Gets or sets the ward group.
        /// </summary>
        /// <value>
        /// The ward.
        /// </value>
        public string WardGroupName { get; set; }

        /// <summary>
        /// Gets or sets the name of the ward.
        /// </summary>
        /// <value>
        /// The name of the ward.
        /// </value>
        public string WardName { get; set; }

        /// <summary>
        /// Gets or sets the root bed id from edit page.
        /// </summary>
        /// <value>
        /// The root bed id.
        /// </value>
        public string RootBedId { get; set; }

        /// <summary>
        /// Gets or sets the extension bed id from edit page.
        /// </summary>
        /// <value>
        /// The extension bed id.
        /// </value>
        public string ExtensionBedId { get; set; }

        /// <summary>
        /// Gets or sets the root ward group id from ward occupancy page.
        /// </summary>
        /// <value>
        /// The root ward id.
        /// </value>
        public string RootWardGroupId { get; set; }

        /// <summary>
        /// Gets or sets the extension ward group id from ward occupancy page.
        /// </summary>
        /// <value>
        /// The extension ward id.
        /// </value>
        public string ExtensionWardGroupId { get; set; }

        /// <summary>
        /// Gets or sets the bed status code from ward occupancy page.
        /// </summary>
        /// <value>
        /// The bed status.
        /// </value>
        public string BedStatusCode { get; set; }

        /// <summary>
        /// Gets or sets the name of the bed status from ward occupancy page.
        /// </summary>
        /// <value>
        /// The name of the bed status.
        /// </value>
        public string BedStatusName { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is from summary report.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if this instance is from summary report; otherwise, <c>false</c>.
        /// </value>
        public bool IsFromSummaryReport { get; set; }

        /// <summary>
        /// Gets or sets the summary report return path.
        /// </summary>
        /// <value>
        /// The summary report return path.
        /// </value>
        public string SummaryReportReturnPath { get; set; }

        /// <summary>
        /// Gets or sets the summary report return text.
        /// </summary>
        /// <value>
        /// The summary report return text.
        /// </value>
        public string SummaryReportReturnText { get; set; }

        /// <summary>
        /// Gets or sets the visn root used in visn summary report.
        /// </summary>
        /// <value>
        /// The visn root used in visn summary report.
        /// </value>
        public string VisnRoot { get; set; }

        /// <summary>
        /// Gets or sets the visn extension used in visn summary report.
        /// </summary>
        /// <value>
        /// The visn extension used in visn summary report.
        /// </value>
        public string VisnExtension { get; set; }
    }
}