﻿using System;
using System.Web;
using System.Web.Mvc;
using BMS.Web.Models;
using BMS.Facade.Data;
using BMS.Facade;
using Microsoft.Web.Mvc;
using BMS.Utils;
using BMS.Web.App_GlobalResource;
using BMS.ServicesWrapper.EIS;
using System.Web.Security;
using BMS.Authentication;
using System.Linq;
using InfoWorld.HL7.ITS;
using System.Collections.Generic;

namespace BMS.Web.Controllers
{
    [ValidateInput(false)]
    public class WardWhiteboardUrlController : Controller
    {
        //
        // GET: /WardWhiteboardClassThree/

        public ActionResult Index(string facilityCode, string wardName, string splitScreen, String displayPTCode, string genderColorCode, string sortBy, string displayFooterCensus, string displayStaffAttending, int? scrollRate)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                WardWhiteboardUrlViewModel model = new WardWhiteboardUrlViewModel();
                model.WasLoginUnsuccessful = false;
                if (string.IsNullOrEmpty(facilityCode))
                    ModelState.AddModelError(string.Empty, Strings.DisplayFacilityMissingMessage);
                else
                {
                    Facility facility = EISFactory.InstanceWindows.GetFacilityByCode(facilityCode);
                    if (facility == null || facility.Id == null)
                        ModelState.AddModelError(string.Empty, Strings.DisplayFacilityNotFoundMessage);
                    else
                    {
                        model.FacilityId = facility.Id;
                        FacilitySettings settings = FacadeManager.ConfigurationInterface.GetFacilitySettings(model.FacilityId);
                        // from EMS to Kiosk
                        if (string.IsNullOrEmpty(settings.KioskDefaultUserName) || string.IsNullOrEmpty(settings.KioskDefaultPassword))
                            ModelState.AddModelError(string.Empty, Strings.DisplayFacilityKioskUserNotFoundMessage);
                        else
                        {
                            model.FacilitySettings = settings;
                            if (TryLogOn(model))
                            {
                                string divisionExtenstion = string.Empty;
                                string delimeter = ", ";
                                if (string.IsNullOrWhiteSpace(wardName))
                                {
                                    ModelState.AddModelError(string.Empty, Strings.DisplayDivisionMissingMessage);
                                }
                                else
                                {
                                    if (wardName == Constants.ALL)
                                        divisionExtenstion = (default(Guid)).ToString();
                                    else
                                    {
                                        Division division = EISFactory.InstanceWindows.GetDivisions(model.FacilityId).Where(a => a.Name == wardName).FirstOrDefault();
                                        if (division != null && division.Id != null)
                                        {
                                            divisionExtenstion = division.Id.extension;
                                        }
                                        else
                                        {
                                            ModelState.AddModelError(string.Empty, Strings.DisplayDivisionNotFoundMessage);
                                        }
                                    }
                                }

                                if (string.IsNullOrWhiteSpace(splitScreen))
                                    ModelState.AddModelError(string.Empty, string.Format(Strings.DisplayParameterMissingMessage, "splitScreen"));
                                else
                                {
                                    if (splitScreen != Constants.No && splitScreen != Constants.Yes)
                                        ModelState.AddModelError(string.Empty, string.Format(Strings.DisplayAvailableValuesMessage, "splitScreen", Constants.No + delimeter + Constants.Yes));
                                }

                                if (string.IsNullOrWhiteSpace(displayFooterCensus))
                                    ModelState.AddModelError(string.Empty, string.Format(Strings.DisplayParameterMissingMessage, "displayFooterCensus"));
                                else
                                {
                                    if (displayFooterCensus != Constants.No && displayFooterCensus != Constants.Yes)
                                        ModelState.AddModelError(string.Empty, string.Format(Strings.DisplayAvailableValuesMessage, "displayFooterCensus", Constants.No + delimeter + Constants.Yes));
                                }


                                if (string.IsNullOrWhiteSpace(displayPTCode))
                                    ModelState.AddModelError(string.Empty, string.Format(Strings.DisplayParameterMissingMessage, "displayPTCode"));
                                else
                                {
                                    List<CD> displayPTCodes = FacadeManager.VocabularyInterface.GetVocabulary(Facade.Data.Util.Vocabulary.PTDisplay).ToList();
                                    if (displayPTCodes.Where(a => a.code == displayPTCode).FirstOrDefault() == null)
                                    {
                                        ModelState.AddModelError(string.Empty, string.Format(Strings.DisplayAvailableValuesMessage, "displayPTCode", displayPTCodes.Select(a => a.code).Aggregate((i, j) => i + delimeter + j)));
                                    }
                                }

                                if (string.IsNullOrWhiteSpace(genderColorCode))
                                    ModelState.AddModelError(string.Empty, string.Format(Strings.DisplayParameterMissingMessage, "genderColorCode"));
                                else
                                {
                                    List<CD> genderColorCodes = FacadeManager.VocabularyInterface.GetVocabulary(Facade.Data.Util.Vocabulary.GenderColor).ToList();
                                    if (genderColorCodes.Where(a => a.code == genderColorCode).FirstOrDefault() == null)
                                    {
                                        ModelState.AddModelError(string.Empty, string.Format(Strings.DisplayAvailableValuesMessage, "genderColorCode", genderColorCodes.Select(a => a.code).Aggregate((i, j) => i + delimeter + j)));
                                    }
                                }

                                if (string.IsNullOrWhiteSpace(displayStaffAttending))
                                    ModelState.AddModelError(string.Empty, string.Format(Strings.DisplayParameterMissingMessage, "displayStaffAttending"));
                                else
                                {
                                    if (displayStaffAttending != Constants.STAFF_ATTENDING && displayStaffAttending != Constants.STAFF && displayStaffAttending != Constants.ATTENDING)
                                    {
                                        ModelState.AddModelError(string.Empty, string.Format(Strings.DisplayAvailableValuesMessage, "displayStaffAttending", Constants.STAFF_ATTENDING + delimeter + Constants.STAFF + delimeter + Constants.ATTENDING));
                                    }
                                }

                                if (!string.IsNullOrWhiteSpace(sortBy))
                                {
                                    if (displayStaffAttending != Constants.SORT_BY_STAFF_OR_ATTENDING_ASCENDING && displayStaffAttending != Constants.SORT_BY_STAFF_OR_ATTENDING_DESCENDING && displayStaffAttending != Constants.SORT_BY_WARD_ASCENDING && displayStaffAttending != Constants.SORT_BY_WARD_DESCENDING)
                                    {
                                        ModelState.AddModelError(string.Empty, string.Format(Strings.DisplayAvailableValuesMessage, "sortBy", Constants.SORT_BY_STAFF_OR_ATTENDING_ASCENDING + delimeter + Constants.SORT_BY_STAFF_OR_ATTENDING_DESCENDING + delimeter + Constants.SORT_BY_WARD_ASCENDING + delimeter + Constants.SORT_BY_WARD_DESCENDING));
                                    }
                                }

                                if (scrollRate != null)
                                {

                                    if (!(scrollRate is int))
                                    {
                                        ModelState.AddModelError(string.Empty, Strings.DisplayScrollRateValueMessage);
                                    }
                                }

                                if (ModelState.IsValid)
                                {
                                    User user = FacadeManager.UserInterface.GetProfile();
                                    return this.RedirectToAction<WardWhiteboardController>(act => act.WardWhiteBoard(BaseController.EncryptQueryString(new string[] { "divisionId", "splitScreen", "displayPTCode", "genderColorCode", "sortBy", "displayFooterCensus", "displayStaffAttending", "scrollRate", "scrollValue", "scrollDirection", "facilityCode", "isFromKiosk" }, new string[] { divisionExtenstion, splitScreen, displayPTCode, genderColorCode, sortBy, displayFooterCensus, displayStaffAttending, scrollRate.HasValue ? scrollRate.Value.ToString() : "0", null, null, facility.Code, "1" }, user.Salt)));
                                }
                            }

                        }
                    }

                }
                return View(model);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        private bool TryLogOn(WardWhiteboardUrlViewModel model)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (HttpContext.User.Identity.IsAuthenticated)
                {
                    System.Web.SessionState.HttpSessionState currentSession = System.Web.HttpContext.Current.Session;
                    MvcApplication.SessionEnd(currentSession);
                    currentSession.Clear();
                    FormsAuthentication.SignOut();
                }
                ValidateUser(model);
                if (ModelState.IsValid)
                    return true;
                // If we got this far, something failed, redisplay form
                FormsAuthentication.SignOut();
                System.Web.HttpContext.Current.Session.Abandon();
                return false;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        private void ValidateUser(WardWhiteboardUrlViewModel model)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (!ModelState.IsValid)
                    return;
                try
                {
                    // from EMS to Kiosk
                    if (Membership.ValidateUser(model.FacilitySettings.KioskDefaultUserName, Encryptor.Decrypt(model.FacilitySettings.KioskDefaultPassword)))
                    {
                        User user = FacadeManager.UserInterface.GetProfile();
                        Facility facility = FacadeManager.EntityInterface.GetFacility(model.FacilityId);
                        FacadeManager.UserInterface.InsertLoggedUser(ProxyManager.GetCurrentSessionID2(), user.UserName, facility, facility.VistaSite.Visn);
                        if (!FacadeManager.UserInterface.CheckBMSReadPermission(user, model.FacilityId))
                            ModelState.AddModelError(string.Empty, "The user name does not have permissions for the selected facility.");
                        else
                        {
                            FormsAuthentication.SetAuthCookie(model.FacilitySettings.KioskDefaultUserName, false);
                            SetModelOnSuccessfullyLogOn(model);
                        }
                    }
                    else
                    {
                        model.WasLoginUnsuccessful = true;
                        ModelState.AddModelError(string.Empty, "The user name or password provided is incorrect.");
                    }
                }
                catch (UserHasNoProfileException)
                {
                    ModelState.AddModelError(string.Empty, "The user does not have a profile. Please contact the administrator.");
                }
                catch (UserHasNoRoleException)
                {
                    ModelState.AddModelError(string.Empty, "The user does not have a user group associated. Please contact the administrator.");
                }
                catch (Exception e)
                {
                    ModelState.AddModelError(string.Empty, "There was an error when trying to login: " + e.Message);
                }

            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        private void SetModelOnSuccessfullyLogOn(WardWhiteboardUrlViewModel model)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                User user = FacadeManager.UserInterface.GetProfile();
                Facility facility = FacadeManager.EntityInterface.GetFacility(model.FacilityId);
                user.Facility = user.DefaultFacility = facility;
                user.VistaSite = facility.VistaSite;
                user.Visn = facility.VistaSite.Visn;
                if (user.Visn == null)
                {
                    ModelState.AddModelError(string.Empty, "The facility doesn't have an associated VISN.");
                    return;
                }
                user.Region = facility.VistaSite.Visn.Region;
                if (user.Region == null)
                {
                    ModelState.AddModelError(string.Empty, "The VISN on facility doesn't have an associated Region.");
                    return;
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
