﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

namespace BMS.Web.Controllers.Shared
{
    public class XssModelMetadataProvider : DataAnnotationsModelMetadataProvider
    {
        protected override ModelMetadata CreateMetadata(IEnumerable<Attribute> attributes, Type containerType, Func<object> modelAccessor, Type modelType, string propertyName)
        {
            var metaData = base.CreateMetadata(attributes, containerType, modelAccessor, modelType, propertyName);

            if (attributes.OfType<ValidateXssAttribute>().Any())
                metaData.AdditionalValues.Add("AddXssKey", true);

            return metaData;
        }
    }
}