﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using Microsoft.Web.Mvc;
using BMS.Web.Models;
using BMS.Facade;
using BMS.Facade.Data;
using InfoWorld.EVS.CTSMAPI;
using BMS.Utils;
using InfoWorld.HL7.ITS;
using System.Text.RegularExpressions;
using BMS.Web.Views;
using BMS.Web.App_GlobalResource;

namespace BMS.Web.Controllers
{
    [ValidateInput(false)]
    public class AdminSpecialtyAssociationController : BaseController
    {
        [ReadPermissionAuthFilter]
        public ActionResult Index(string p)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                AdminSpecialtyAssociationViewModel model = new AdminSpecialtyAssociationViewModel();
                FillModel(model, string.IsNullOrEmpty(p) ? null : QueryStrings["code"], string.IsNullOrEmpty(p) ? null : QueryStrings["vocabularyDomain"]);
                return View(model);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        [HttpPost]
        [UpdatePermissionAuthFilter]
        public ActionResult Index(AdminSpecialtyAssociationViewModel input)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                ModelState.Clear();
                bool isModelError = SaveVocabulary(input);
                if (isModelError)
                {
                    FillModel(input, null, null);                    
                    return View(input);
                }
                ClearEditFields(input);
                return this.RedirectToAction<AdminSpecialtyAssociationController>(act => act.Index((string)null));
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        [ReadPermissionAuthFilter]
        public ActionResult Delete(string p)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                AdminSpecialtyAssociationViewModel model = new AdminSpecialtyAssociationViewModel();
                model.CodeToDelete = QueryStrings["code"];
                model.VocabularyDomainToDelete = QueryStrings["vocabularyDomain"];
                CD cd = null;
                if (model.VocabularyDomainToDelete.Equals(Util.Vocabulary.NUMA.ToString()))
                    cd = FacadeManager.VocabularyInterface.GetVocabulary(Util.Vocabulary.NUMA).Where(a => a.code.Equals(model.CodeToDelete, StringComparison.InvariantCultureIgnoreCase)).FirstOrDefault();
                else if (model.VocabularyDomainToDelete.Equals(Util.Vocabulary.HAvBED.ToString()))
                    cd = FacadeManager.VocabularyInterface.GetVocabulary(Util.Vocabulary.HAvBED).Where(a => a.code.Equals(model.CodeToDelete, StringComparison.InvariantCultureIgnoreCase)).FirstOrDefault();
                if (cd != null)
                    model.DisplayNameToDelete = cd.displayName;
                model.LoggedUser = loggedUser;
                return View(model);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        [HttpPost]
        [UpdatePermissionAuthFilter]
        public ActionResult Delete(AdminSpecialtyAssociationViewModel input)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (!string.IsNullOrEmpty(input.CodeToDelete) && !string.IsNullOrEmpty(input.VocabularyDomainToDelete))
                {
                    CD cd = null;
                    if (input.VocabularyDomainToDelete.Equals(Util.Vocabulary.NUMA.ToString()))
                        cd = FacadeManager.VocabularyInterface.GetVocabulary(Util.Vocabulary.NUMA).Where(a => a.code.Equals(input.CodeToDelete, StringComparison.InvariantCultureIgnoreCase)).FirstOrDefault();
                    else if (input.VocabularyDomainToDelete.Equals(Util.Vocabulary.HAvBED.ToString()))
                        cd = FacadeManager.VocabularyInterface.GetVocabulary(Util.Vocabulary.HAvBED).Where(a => a.code.Equals(input.CodeToDelete, StringComparison.InvariantCultureIgnoreCase)).FirstOrDefault();
                    if (cd != null)
                    {
                        List<CDWithProperties> specialtyList = FacadeManager.VocabularyInterface.GetVistaSpecialties();
                        foreach (CDWithProperties item in specialtyList)
                        {
                            if (item.Properties != null && item.Properties.Count > 0)
                            {
                                item.Properties.Remove(item.Properties.Where(a => a.PropertyName.text.Equals(input.VocabularyDomainToDelete, StringComparison.InvariantCultureIgnoreCase) && a.PropertyValue.text.Equals(cd.code, StringComparison.InvariantCultureIgnoreCase)).FirstOrDefault());
                                FacadeManager.VocabularyInterface.UpdateConcept(item);
                            }
                        }
                        FacadeManager.VocabularyInterface.DeleteConcept(cd);
                    }
                }
                return this.RedirectToAction<AdminSpecialtyAssociationController>(act => act.Index((string)null));
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        #region Private Methods

        private void FillModel(AdminSpecialtyAssociationViewModel model, string code, string vocabularyDomain)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                model.HAvBEDList = FacadeManager.VocabularyInterface.GetVocabulary(Util.Vocabulary.HAvBED).OrderBy(a => a.displayName).ToList();
                model.HAvBEDList.Insert(0, new CD { code = string.Empty, displayName = string.Empty });
                model.NUMAList = FacadeManager.VocabularyInterface.GetVocabulary(Util.Vocabulary.NUMA).OrderBy(a => a.displayName).ToList();
                model.NUMAList.Insert(0, new CD { code = string.Empty, displayName = string.Empty });
                model.SpecialtyList = FacadeManager.VocabularyInterface.GetVistaSpecialties().OrderBy(a => a.displayName).ToList();
                if (!string.IsNullOrEmpty(vocabularyDomain))
                {
                    if (vocabularyDomain.Equals(Util.Vocabulary.NUMA.ToString()))
                    {
                        model.NUMAName = model.NUMAList.Where(a => a.code == code).FirstOrDefault().displayName;
                        model.NUMACode = code;
                    }
                    else if (vocabularyDomain.Equals(Util.Vocabulary.HAvBED.ToString()))
                    {
                        model.HAvBEDName = model.HAvBEDList.Where(a => a.code == code).FirstOrDefault().displayName;
                        model.HAvBEDCode = code;
                    }
                    else if (vocabularyDomain.Equals(Util.Vocabulary.VistaSpecialty.ToString()))
                    {
                        SpecialtyItemViewModel specialty = model.SpecialtyListExtended.Where(a => a.Specialty.code == code).FirstOrDefault();
                        model.SpecialtyName = specialty.Specialty.displayName;
                        model.SpecialtyCode = code;
                        if (!string.IsNullOrEmpty(specialty.NUMA))
                            model.NUMASelected = specialty.Specialty.Properties.Where(a => a.PropertyName.text.Equals(Constants.NUMA)).FirstOrDefault().PropertyValue.text;
                        else
                            model.NUMASelected = string.Empty;
                        if (!string.IsNullOrEmpty(specialty.HAvBED))
                            model.HAvBEDSelected = specialty.Specialty.Properties.Where(a => a.PropertyName.text.Equals(Constants.HAvBED)).FirstOrDefault().PropertyValue.text;
                        else
                            model.HAvBEDSelected = string.Empty;
                    }
                }
                model.LoggedUser = loggedUser;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        private void ClearEditFields(AdminSpecialtyAssociationViewModel model)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                model.ButtonSaveHAvBED = null;
                model.ButtonSaveNUMA = null;
                model.ButtonSaveSpecialty = null;
                model.HAvBEDCode = null;
                model.HAvBEDName = null;
                model.HAvBEDSelected = null;
                model.NUMACode = null;
                model.NUMAName = null;
                model.NUMASelected = null;
                model.SpecialtyCode = null;
                model.SpecialtyName = null;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        private bool SaveVocabulary(AdminSpecialtyAssociationViewModel model)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                Regex regEx = new Regex("[\\~#%&*{}/:<>?|\"-'^()]");
                string code = string.Empty;
                bool isModelError = false;
                if (!string.IsNullOrEmpty(model.ButtonSaveNUMA))
                {
                    if (string.IsNullOrEmpty(model.NUMACode))
                    {
                        code = Regex.Replace(regEx.Replace(model.NUMAName, " "), @"\s+", " ");
                        code = code.Trim().Replace(" ", "_");
                    }
                    else
                        code = model.NUMACode;
                    List<CD> vocabularies = FacadeManager.VocabularyInterface.GetVocabulary(Util.Vocabulary.NUMA);
                    if (string.IsNullOrEmpty(model.NUMACode) && vocabularies.Where(a => a.code.Equals(code, StringComparison.InvariantCultureIgnoreCase)).FirstOrDefault() != null)
                    {
                        ViewData[InputHelpers.FormNameKey] = Strings.NUMA;
                        ModelState.AddModelError(string.Empty, "NUMA item already exists!");
                        isModelError = true;
                    }
                    else if (vocabularies.Where(a => a.displayName.Equals(model.NUMAName, StringComparison.InvariantCultureIgnoreCase)).FirstOrDefault() != null)
                    {
                        ViewData[InputHelpers.FormNameKey] = Strings.NUMA;
                        ModelState.AddModelError(string.Empty, "NUMA item already exists!");
                        isModelError = true;
                    }
                    else
                    {
                        CD numa = new CD()
                        {
                            code = code,
                            codeSystem = Constants.NUMACodeSystem,
                            codeSystemName = Constants.NUMA,
                            displayName = model.NUMAName
                        };
                        if (string.IsNullOrEmpty(model.NUMACode))
                            FacadeManager.VocabularyInterface.InsertConcept(numa);
                        else
                            FacadeManager.VocabularyInterface.UpdateConcept(numa);
                    }
                }
                else if (!string.IsNullOrEmpty(model.ButtonSaveHAvBED))
                {
                    if (string.IsNullOrEmpty(model.HAvBEDCode))
                    {
                        code = Regex.Replace(regEx.Replace(model.HAvBEDName, " "), @"\s+", " ");
                        code = code.Trim().Replace(" ", "_");
                    }
                    else
                        code = model.HAvBEDCode;
                    List<CD> vocabularies = FacadeManager.VocabularyInterface.GetVocabulary(Util.Vocabulary.HAvBED);
                    if (string.IsNullOrEmpty(model.HAvBEDCode) && vocabularies.Where(a => a.code.Equals(code, StringComparison.InvariantCultureIgnoreCase)).FirstOrDefault() != null)
                    {
                        ViewData[InputHelpers.FormNameKey] = Strings.HAvBED;
                        ModelState.AddModelError(string.Empty, "HAvBED item already exists!");
                        isModelError = true;
                    }
                    else if (vocabularies.Where(a => a.displayName.Equals(model.HAvBEDName, StringComparison.InvariantCultureIgnoreCase)).FirstOrDefault() != null)
                    {
                        ViewData[InputHelpers.FormNameKey] = Strings.HAvBED;
                        ModelState.AddModelError(string.Empty, "HAvBED item already exists!");
                        isModelError = true;
                    }
                    else
                    {
                        CD havBed = new CD()
                        {
                            code = code,
                            codeSystem = Constants.HAvBEDCodeSystem,
                            codeSystemName = Constants.HAvBED,
                            displayName = model.HAvBEDName
                        };
                        if (string.IsNullOrEmpty(model.HAvBEDCode))
                            FacadeManager.VocabularyInterface.InsertConcept(havBed);
                        else
                            FacadeManager.VocabularyInterface.UpdateConcept(havBed);
                    }
                }
                else if (!string.IsNullOrEmpty(model.ButtonSaveSpecialty))
                {
                    CDWithProperties specialty = FacadeManager.VocabularyInterface.GetVistaSpecialties().Where(a => a.code == model.SpecialtyCode).FirstOrDefault();
                    if (specialty != null)
                    {
                        specialty.Properties = new List<ConceptProperty>();
                        ConceptProperty property = null;
                        if (!string.IsNullOrEmpty(model.NUMASelected))
                        {
                            property = new ConceptProperty(new ST(Constants.NUMA), new ST(model.NUMASelected), new ST(Constants.EVS_Language_code), new ST(Constants.MIME_TEXT), null);
                            specialty.Properties.Add(property);
                        }
                        if (!string.IsNullOrEmpty(model.HAvBEDSelected))
                        {
                            property = new ConceptProperty(new ST(Constants.HAvBED), new ST(model.HAvBEDSelected), new ST(Constants.EVS_Language_code), new ST(Constants.MIME_TEXT), null);
                            specialty.Properties.Add(property);
                        }
                        FacadeManager.VocabularyInterface.UpdateConcept(specialty);
                    }
                }
                return isModelError;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        #endregion
    }
}
