﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaIntegration.Data;

namespace BMS.VistaIntegration.VistA
{
    public interface IVistASession : IDisposable
    {
        /// <summary>
        /// Gets the vistA site.
        /// </summary>
        VistASite VistASite { get; }

        /// <summary>
        /// Opens the session for reading data from vista.
        /// </summary>
        /// <param name="connection">The vist asite.</param>
        void Open(VistAConnectionInfo connection);

        /// <summary>
        /// Close the session.
        /// </summary>
        void Close();

        /// <summary>
        /// Makes the vistA query.
        /// </summary>
        /// <returns></returns>
        IVistAQuery MakeQuery();

        /// <summary>
        /// Determines whether this instance is alive.
        /// </summary>
        /// <returns>
        ///   <c>true</c> if this instance is alive; otherwise, <c>false</c>.
        /// </returns>
        bool IsAlive();
    }
}
