﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.Utils;
using BMS.VistaIntegration.Data;

namespace BMS.VistaIntegration
{
    public static class Utilities
    {
        private static readonly VistaDataType[] vistaTypes = new VistaDataType[]
        {
            VistaDataType.HospitalLocation,
            VistaDataType.Patient,
            VistaDataType.RoomBed,
            VistaDataType.WardLocation,
            VistaDataType.ADT,
            VistaDataType.Specialty,
            VistaDataType.TreatingSpecialty,
            VistaDataType.FacilityMovementType,
            VistaDataType.OrderableItem,
            VistaDataType.MedicalCenterDivision  ,
            VistaDataType.WaitingList
        };

        public static IList<VistaDataType> VistATypes
        {
            get
            {
                DateTime entryInLogMethodTime = DateTime.UtcNow;
                if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
                }
                try
                {
                    return vistaTypes;
                }
                finally
                {
                    if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                    {
                        InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                    }
                }
            }
        }

        public static String ToString(IEnumerable<VistaDataType> types)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                StringBuilder sb = new StringBuilder();
                types.ForEach(s =>
                {
                    sb.Append(s.ToString());
                    sb.Append(",");
                });
                sb.Remove(sb.Length - 1, 1);
                return sb.ToString();
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public static String ToString(VistaDataType types)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                return ToString(GetVistaTypes(types));
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public static IEnumerable<VistaDataType> GetVistaTypes(VistaDataType types)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                return vistaTypes.Where(e => (types & e) == e);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }


        public static DateTime ConvertToSiteDateTime(this VistASite site, DateTime value)
        {
            if (value.Kind == DateTimeKind.Local)
                throw new InvalidOperationException();

            DateTime result;
            if(value.Kind != DateTimeKind.Utc)
                result = DateTime.SpecifyKind(value, DateTimeKind.Utc);

            result = TimeZoneInfo.ConvertTimeFromUtc(value, site.TimeZone);
            return result;
        }

        public static DateTime ConvertToUtcDateTime(this VistASite site, DateTime value)
        {
            if (value.Kind != DateTimeKind.Unspecified)
                throw new InvalidOperationException();

            DateTime result =  TimeZoneInfo.ConvertTimeToUtc(value, site.TimeZone);
            return result;
        }

        public static DateTime? ConvertToSiteNullableDateTime(this VistASite site, DateTime? value)
        {
            if (!value.HasValue) return null;
            return ConvertToSiteDateTime(site, value.Value);
        }

        public static DateTime? ConvertToUtcNullableDateTime(this VistASite site, DateTime? value)
        {
            if (!value.HasValue) return null;
            return ConvertToUtcDateTime(site, value.Value);
        }
    }
}
