﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaWorker2.Writer;
using BMS.VistaIntegration.VistA;
using BMS.VistaIntegration.Data;
using BMS.VistaIntegration.LogCheckers;
using BMS.ServicesWrapper.EIS;
using BMS.ServicesWrapper.Security;
using BMS.ServicesWrapper.EVS;
using FC = BMS.Facade.Data;
using BMS.ServicesWrapper.BMService;
using BMS.Utils;
using BMS.VistaWorker2.Writer.Implementation.Concrete;
using BMS.DataContracts;
using InfoWorld.HL7.ITS;

namespace BMS.VistaIntegration.Operations.Concrete.EntryProcessors
{
    public class PatientAppointmentsProcessor : MultipleEntryProcessor
    {
        public Parameter Parameter { get; private set; }
        public IVistAQuery Query { get; private set; }
        public PatientAppointmentsProcessor(IWriterManager writerManager, Parameter parameter, IVistAQuery query)
            : base(writerManager)
        {
            if (parameter.Type != VistaDataType.PatientAppointment)
                throw new InvalidOperationException();
            Parameter = parameter;
            Query = query;
            InitEntriesProcessor(GetEntitiesProcessor());
        }

        ListEntryProcessor<T> GetEntitiesProcessor<T>(Func<IList<T>> fetchFunc, Comparison<T> comparison, Func<T, DateTime?> filterDateTimeFunc)
        {
            IList<T> list = fetchFunc();
            return new ListEntryProcessor<T>(WriterManager, list, filterDateTimeFunc);
        }

        public IVistaIntegrationLogChecker LogChecker { get; private set; }

        private IList<IEntryProcessor> GetEntitiesProcessor()
        {            
            List<IEntryProcessor> result = new List<IEntryProcessor>();
            List<VistaIntegrationLog> logs = new List<VistaIntegrationLog>();
            string domain = SecurityFactory.InstanceWindows.GetCurrentDomain();
            II vistASiteId = new II(domain, WriterManager.Site.Id);
            string FormatDateTime = "MM/dd/yyyy HH:mm:ss";

            List<BMS.DataContracts.HospitalLocationAppointment> hlList = BMSFactory.BedManagerOperationsClientWindows.GetHospitalLocationsAppointment(null, Guid.Parse(vistASiteId.extension));
            List<FC.HospitalLocation> hospitalLocations = EISFactory.InstanceWindows.GetHospitalLocationsByIds(hlList.Select<BMS.DataContracts.HospitalLocationAppointment, II>(a => a.HospitalLocationId).ToList(), vistASiteId);
            
            if (hospitalLocations != null)
            {
                var clincsIens = hospitalLocations.Select<FC.HospitalLocation, string>(a => a.Ien).Distinct().ToList();
                if (clincsIens.Any())
                {
                    ListEntryProcessor<PatientAppointment> s1 = null;
                    if (Parameter.JobLaunchType == JobLaunchType.Automatic)
                    {
                        s1 = GetEntitiesProcessor<PatientAppointment>(() => { return Query.GetPatientAppointments(Parameter.StartDateParam, null, null, clincsIens); },
                                            (x1, x2) => DateTime.Compare(x1.AppointmentDateTime, x2.AppointmentDateTime), o => o.AppointmentDateTime);
                    }
                    else
                    {
                        s1 = GetEntitiesProcessor<PatientAppointment>(() => { return Query.GetPatientAppointments(Parameter.StartDateParam, Parameter.EndDateParam, null, clincsIens); },
                                            (x1, x2) => DateTime.Compare(x1.AppointmentDateTime, x2.AppointmentDateTime), o => o.AppointmentDateTime);
                    }
                    s1.Entries.ForEach(i => logs.Add(new VistaIntegrationLog() { File = VistaFiles.PatientAppointment, Ien = string.Format("{0}_{1}", i.Patient.IEN, i.AppointmentDateTime.ToString(FormatDateTime)) }));
                    result.Add(s1);
                    LogChecker = new HashSetLogChecker(logs, WriterManager.Site.Name);
                    result.ForEach(s => s.InitLogCheck(LogChecker));
                }
                clincsIens = null;
            }
            hlList = null;
            hospitalLocations = null;
            return result;
        }
    }
}
