﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaWorker2.Writer;
using BMS.VistaIntegration.VistA;
using BMS.VistaIntegration.Data;
using BMS.VistaIntegration.LogCheckers;
using BMS.ServicesWrapper.EIS;
using BMS.ServicesWrapper.Security;
using BMS.ServicesWrapper.EVS;
using BMS.VistaWorker2.Writer.Implementation.Concrete;
using BMS.DataContracts;
using BMS.Utils;
using FC = BMS.Facade.Data;

namespace BMS.VistaIntegration.Operations.Concrete.EntryProcessors
{
    public class OrderProcessor : MultipleEntryProcessor
    {
        public Parameter Parameter { get; private set; }
        public IVistAQuery Query { get; private set; }
        public OrderProcessor(IWriterManager writerManager, Parameter parameter, IVistAQuery query)
            : base(writerManager)
        {
            if (parameter.Type != VistaDataType.Order)
                throw new InvalidOperationException();
            Parameter = parameter;
            Query = query;
            InitEntriesProcessor(GetEntitiesProcessor());
        }

        ListEntryProcessor<T> GetEntitiesProcessor<T>(Func<IList<T>> fetchFunc, Comparison<T> comparison, Func<T, DateTime?> filterDateTimeFunc)
        {
            IList<T> list = fetchFunc();
            if (list != null && list.Count > 0)
                list = (from a in (list as List<OrderAction>) orderby long.Parse(a.OrderId) select a).ToList() as List<T>;
            return new ListEntryProcessor<T>(WriterManager, list, filterDateTimeFunc);
        }

        public IVistaIntegrationLogChecker LogChecker { get; private set; }

        private IList<IEntryProcessor> GetEntitiesProcessor()
        {            
            List<IEntryProcessor> result = new List<IEntryProcessor>();
            List<VistaIntegrationLog> logs = new List<VistaIntegrationLog>();
            string FormatDateTime = "MM/dd/yyyy HH:mm:ss";

            var orderableItems = Facade.FacadeUtil.GetOrderableItem(EVSFactory.InstanceWindows, WriterManager.Site.Name).Select(s => GetOrderableItemIen(s.code)).Distinct().ToList();
                        
            var s1 = GetEntitiesProcessor<OrderAction>(() => Query.GetOrderActions(Parameter.StartDateParam, Parameter.EndDateParam, null, orderableItems), null, null);
            s1.Entries.ForEach(i => logs.Add(new VistaIntegrationLog() { File = VistaFiles.Order, Ien = string.Format("{0}_{1}", i.OrderId, i.DateTimeOrdered.ToString(FormatDateTime)) }));
            result.Add(s1);
            LogChecker = new HashSetLogChecker(logs, WriterManager.Site.Name);
            result.ForEach(s => s.InitLogCheck(LogChecker));
            return result;
        }

        private string GetOrderableItemIen(string code)
        {
            int index = code.LastIndexOf('_');
            return code.Substring(index + 1);
        }
    }
}
