﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.Utils;
using BMS.VistaIntegration.Dal;
using BMS.VistaIntegration.Data;

namespace BMS.VistaIntegration.Mock
{
    public class VistADalMock : IVistADal
    {
        public SiteData GetData(VistASite site)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                Dictionary<VistaDataType, DateTime?> dictionary = Enum.GetValues(typeof(VistaDataType))
                     .Cast<VistaDataType>()
                     .ToDictionary(s => s, s => new Nullable<DateTime>());

                SiteData siteData = new SiteData(site, dictionary);

                return siteData;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void UpdateData(VistASite site, VistaDataType type, DateTime? lastRunning)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                string msj = string.Format("Update last running datetime for type {0} and site {1} with {2}",
                    type,
                    site.Name,
                    lastRunning.HasValue ? lastRunning.Value.ToString() : "NULL");
                Console.WriteLine(msj);
                Console.WriteLine("----------------------------------------------");
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void DeleteData(VistASite site)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                string msj = string.Format("Delete data for site {0}", site.Name);
                Console.WriteLine(msj);
                Console.WriteLine("----------------------------------------------");
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
