﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ServiceModel;

namespace BMS.VistaIntegration.Mdws
{
    public static class WcfClient
    {

        /// <summary>
        /// Performs the action on the client (a <see cref="ICommunicationObject"/>) using the try-close-finally-abort pattern
        /// </summary>
        /// <typeparam name="TClient">The type of client</typeparam>
        /// <param name="client">The client</param>
        /// <param name="action">The action to perform on the client</param>
        public static void Using<TClient>(TClient client, Action<TClient> action) where TClient : ICommunicationObject
        {
            if (client == null)
            {
                throw new ArgumentNullException("client");
            }
            if (action == null)
            {
                throw new ArgumentNullException("action");
            }

            try
            {
                client.Open();
                action(client);
                client.Close();
            }
            finally
            {
                if (client.State != CommunicationState.Closed)
                {
                    client.Abort();
                }
            }
        }


        /// <summary>
        /// Creates a WCF client channel using a <see cref="ChannelFactory"/> and performs the action on the channel using the try-close-finally-abort pattern
        /// </summary>
        /// <typeparam name="TChannel">The type of channel</typeparam>
        /// <param name="channelFactory">The channel factory</param>
        /// <param name="action">The action to perform on the created channel</param>
        public static void Using<TChannel>(ChannelFactory<TChannel> channelFactory, Action<TChannel> action) where TChannel : class
        {
            if (channelFactory == null)
            {
                throw new ArgumentNullException("channelFactory");
            }
            if (action == null)
            {
                throw new ArgumentNullException("action");
            }

            TChannel clientChannel = channelFactory.CreateChannel();
            try
            {
                channelFactory.Open();
                action(clientChannel);
                channelFactory.Close();
            }
            finally
            {
                if (channelFactory.State != CommunicationState.Closed)
                {
                    channelFactory.Abort();
                }
                clientChannel = null;
            }
        }
    } 
}
