﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mdws2ORM;

namespace BMS.VistaIntegration.Mdws
{
    public class ScreenPeriodBuilder
    {
        private string format;
        private string variable;

        private const string LeftFormat = "{0}>={1}";
        private const string RightFormat = "{0}<{1}";
        private const string LeftAndRightFormat = "{0}>={1},{0}<{2}";

        public ScreenPeriodBuilder Format(string value)
        {
            this.format = value;
            return this;
        }

        public ScreenPeriodBuilder Variable(string value)
        {
            this.variable = value;
            return this;
        }



        public string Build(DateTime? startDateTime, DateTime? endDateTime)
        {
            if (startDateTime.HasValue && endDateTime.HasValue)
                return string.Format(format, string.Format(LeftAndRightFormat, variable, Converters.ToInternalFormat(startDateTime.Value), Converters.ToInternalFormat(endDateTime.Value)));

            if (startDateTime.HasValue)
                return string.Format(format, string.Format(LeftFormat, variable, Converters.ToInternalFormat(startDateTime.Value)));

            if (endDateTime.HasValue)
                return string.Format(format, string.Format(RightFormat, variable, Converters.ToInternalFormat(endDateTime.Value)));

            return string.Empty;
        }
    }
}
