﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaIntegration.Data;
using Mdws2ORM.Maps;

namespace Mdws2ORM.Maps.WF
{
    public class PatientAppointmentMap : SubEntityMapWithParent<PatientAppointment, Patient>
    {
        public override PatientAppointment NewEntity(string ien)
        {
            return new PatientAppointment() { AppointmentDateTime = Converters.ToDateTime(ien) };
        }

        public override string File
        {
            get { return "2.98"; }
        }

        protected override void MapFields()
        {
            MapPointerToFile<HospitalLocation>(".01", (m, s) => m.HospitalLocationId = s, (m, s) => m.HospitalLocation = s);           
            MapDateTime("20", (m, s) => m.DateAppointmentMade = s);
            MapComputed("100", (m, s) => m.CurrentStatus = s, true);
        }

        public override void SetParent(PatientAppointment entity, Patient parent)
        {
            entity.Patient = parent;
        }
    }
}
