﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaIntegration.Data;
using Mdws2ORM.Maps;


namespace Mdws2ORM.Maps.EVS
{
    public class SpecialtyMap : EntityMap<Specialty>
    {
        public override string Location
        {
            get { return "DIC(42.4,"; }
        }

        public override Specialty NewEntity(string ien)
        {
            return new Specialty() { IEN = ien };
        }

        public override string File
        {
            get { return "42.4"; }
        }

        protected override void MapFields()
        {
            MapFreeText(".01", (m, s) => m.Name = s);
        }
    }
}
