﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mdws2ORM.Maps;
using Mdws2ORM;

namespace BMS.VistaIntegration.Mdws.Commands.SubEntityCommands
{
    public abstract class BaseListSubEntityCommand<T, V> : BaseListCommand<T>
        where T : class
        where V : class
    {

        protected virtual string GetSubEntityScreen()
        {
            return string.Empty;
        }

        protected virtual void InitSubEntityParamBuilder(ListParamBuilder builder)
        {
            builder.Screen(GetSubEntityScreen());
        }

        protected override List<T> GetList(ISession session, ListParam param, out Entry lastEntry)
        {
            ListParamBuilder builder = new ListParamBuilder();
            InitSubEntityParamBuilder(builder);
            ListParam subListParam = builder.Build();
            return SubEntityCommandStrategy.Execute<T, V>(session, param, subListParam, this, out lastEntry);
        }

    }
}
