﻿using System;
using System.Linq;
using System.Text;
using System.Collections.Generic;
using Mdws2ORM;
using Mdws2ORM.Maps;
using Mdws2ORM.QuerySvcService;
using BMS.VistaIntegration.Data;
using BMS.VistaIntegration.Mdws.Commands.EntityCommands;
using BMS.VistaIntegration.Mdws.Commands.Concrete;
using BMS.Utils;

namespace BMS.VistaIntegration.Mdws.Commands.Concrete.WF
{
    public class ListAdmittedPatientsCommand
    {
        public string AdmissionIen { get; set; }
        public int? MaxCount { get; set; }
        private const string ScreenFormat = "I $D(^DPT(Y,.105)),$P(^DPT(Y,.105),U,1)<{0}";

        private string GetScreen()
        {
            return string.Format(ScreenFormat, AdmissionIen);
        }

        public List<AdmittedPatient> Execute(ISession session)
        {
            List<AdmittedPatient> result = new List<AdmittedPatient>();
            if (string.IsNullOrEmpty(AdmissionIen))
            {
                Tracer.TraceMessage("ListAdmittedPatientsCommand - Admission Ien was not provided!");
                return result;
            }

            ListParamBuilder builder = new ListParamBuilder();
            builder.Index("ACA");
            builder.Screen(GetScreen());
            if (MaxCount.HasValue)
                builder.Number(MaxCount.Value.ToString());
            
            bool hasMore = true;
            int size = 0, partialSize = 0;
            while (hasMore)
            {
                size = result.Count;
                result.AddRange(session.List<AdmittedPatient>(builder.Build()).Select(s => s.Entity));
                partialSize = result.Count - size;
                hasMore = MaxCount.HasValue ? MaxCount.Value == partialSize : false;
                if (hasMore)                
                    builder.From(result[result.Count - 1].AdmissionIen);                
            }
            return result;
        }
    }
}
