﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaIntegration.Data;
using BMS.VistaIntegration.Mdws.Commands.EntityCommands;
using Mdws2ORM.Maps.EIS;
using Mdws2ORM;

namespace BMS.VistaIntegration.Mdws.Commands.EIS
{
    public class ListRoomBedCommand
    {
        public int? MaxCount { get; set; }
        public bool SecondTimeCall { get; set; }
        public string Ien { get; set; }

        private string GetIdentity()
        {
            return "S X=\"\", b=Y, c=100 I $D(^DG(405.4,Y,\"W\",0)) S a=\"\" F  S a=$O(^DG(405.4,Y,\"W\",a)) Q:a=\"\"  I a>0 S X=X_\",\"_a  D EN^DDIOL(b_U_c_U_X)";
        }

        public List<RoomBed> Execute(ISession session)
        {
            List<RoomBed> result = new List<RoomBed>();
            ListParamBuilder builder = new ListParamBuilder();
            builder.Index("#");
            builder.Screen("");
            if (MaxCount.HasValue)
                builder.Number(MaxCount.Value.ToString());
            builder.Identity(GetIdentity());

            if (!string.IsNullOrEmpty(Ien))
            {
                builder.From(Ien);
                result.AddRange(session.List<RoomBed>(builder.Build()).Select(s => s.Entity));
            }
            else
            {
                bool hasMore = true;
                int size = 0, partialSize = 0;
                while (hasMore)
                {
                    size = result.Count;
                    result.AddRange(session.List<RoomBed>(builder.Build()).Select(s => s.Entity));
                    partialSize = result.Count - size;
                    hasMore = MaxCount.HasValue ? MaxCount.Value == partialSize : false;
                    if (hasMore)
                        builder.From(result[result.Count - 1].IEN);
                }
            }
            return result;
        }
    }
}
