﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaIntegration.Data;
using Mdws2ORM;
using BMS.VistaIntegration.Mdws.Commands.Concrete;
using BMS.Utils;

namespace BMS.VistaIntegration.Mdws.Commands.EIS
{
    public class ListPatientBySsnCommand
    {
        public IEnumerable<string> SSNs { get; set; }

        public IList<Patient> Execute(ISession session)
        {
            List<Patient> result = new List<Patient>();
            ListParamBuilder builder = new ListParamBuilder();
            builder.Index("SSN");
            builder.Number("1");


            foreach (string ssn in SSNs)
            {
                string part = ssn.Replace("-", "");
                ListParam param = builder
                    .Partial(part)
                    .Build();

                Patient patient = session.List<Patient>(param).Select(s => s.Entity).SingleOrDefault();
                if (patient == null || patient.SocialSecurityNumber != ssn)
                {
                    BmsLogger logger = new BmsLogger("ListPatientBySsnCommand");
                    logger.LogFormat(BmsLogger.Level.Warning, "Patient with ssn {0} was not found", ssn);
                }
                else
                {
                    result.Add(patient);
                }
            }

            return result;
        }
    }
}
