﻿using System;
using System.Collections.Generic;
using System.Linq;
using BMS.Facade.Data;
using InfoWorld.HL7.ITS;
using System.IO;
using System.Reflection;
using BMS.Utils;
using System.Diagnostics;
using BMS.ServicesWrapper.EIS;
using BMS.Facade;
using System.Xml.Linq;
using System.Collections;

namespace BMS.Vista.TestEis
{
    public class EisTree
    {
        private readonly string file;

        public EisTree(string file = "test.xml")
        {
            this.file = file;
        }

        private Dictionary<Type, Func<object, IEnumerable>> _dictionary = new Dictionary<Type, Func<object, IEnumerable>>();
        private Func<IEnumerable> _defaultFunc;

        private IEnumerable GetEnumerable(object entity)
        {
            Func<object, IEnumerable> func = null;
            _dictionary.TryGetValue(entity.GetType(), out func);
            return func != null ? func(entity) : Enumerable.Empty<object>();
        }

        private IEnumerable GetEnumerable()
        {
            return _defaultFunc();
        }

        public void AddFunc<T, V>(Func<T, IEnumerable<V>> func) where T : class
        {
            Func<object, IEnumerable> f = o => func(o as T);
            _dictionary[typeof(T)] = f;
        }

        public void AddDefaultFunc<V>(Func<IEnumerable<V>> func)
        {
            _defaultFunc = () => func();
        }

        private void f2(XElement root, IEnumerable entities)
        {
            foreach (var o in entities)
            {
                XElement x = CreateElement(o);
                root.Add(x);
                f2(x, GetEnumerable(o));
            }
        }

        private void f1(XElement root)
        {
            f2(root, GetEnumerable());
        }

        private Dictionary<Type, Func<object, string>> toStringDicitonary = new Dictionary<Type, Func<object, string>>();

        public void AddStringType<T>(Func<T, string> toString) 
        {
            Type type = typeof(T);
            Func<object, string> func = o => toString((T)o);
            toStringDicitonary[type] = func;
        }

        public void Run()
        {
            XDocument doc = new XDocument();
            XElement root = new XElement("EIS");

            f1(root);

            doc.Add(root);
            doc.Save("test.xml");
        }

        private XElement CreateElement(object o)
        {
            Type type = o.GetType();
            XElement element = new XElement(type.Name);
            var properties = type.GetProperties();
            foreach (PropertyInfo p in properties)
            {
                object val = p.GetValue(o, null);
                string stringVal = ToString(val);              
                element.Add(new XAttribute(p.Name, stringVal));
            }
            return element;
        }

        private string ToString(object val)
        {
            if (val == null) return "NULL";
            Type type = val.GetType();

            Func<object,string> func;
            toStringDicitonary.TryGetValue(type,out func);
            return func == null ? val.ToString() : func(val);
          
        }


    }
}
