﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IdentityModel.Claims;
using System.ServiceModel;
using System.Web.SessionState;

namespace BMS.Utils
{
    public class SecurityUtils
    {
        private static Claim GetContextClaim(string claimType)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                Claim result = null;
                if (OperationContext.Current == null || OperationContext.Current.ServiceSecurityContext == null
                   || OperationContext.Current.ServiceSecurityContext.AuthorizationContext == null
                   || OperationContext.Current.ServiceSecurityContext.AuthorizationContext.ClaimSets == null)
                    return result;
                foreach (ClaimSet claimSet in OperationContext.Current.ServiceSecurityContext.AuthorizationContext.ClaimSets)
                {
                    foreach (Claim claim in claimSet)
                        if (claim.ClaimType == claimType)
                        {
                            result = claim;
                            break;
                        }
                    if (result != null)
                        break;
                }
                return result;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
        /// <summary>
        /// Get the current username from the WCF Operation context and security claims.
        /// </summary>
        /// <returns>Full username (domain\username)</returns>
        public static string GetUserName()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                Claim claim = GetContextClaim(UserNameClaimType);
                if (claim != null)
                {
                    return claim.Resource.ToString();
                }
                return string.Empty;

            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        private const string UserNameClaimType = @"urn:oasis:names:tc:SAML:2.0:nameid-format:WindowsDomainQualifiedName/UserName";


    }
}
