﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using InfoWorld.EVS.CTSVAPI;
using BMS.Utils;

namespace BMS.ServicesWrapper.Proxy.EVS.VAPI
{

    [System.Diagnostics.DebuggerStepThroughAttribute()]
    [System.CodeDom.Compiler.GeneratedCodeAttribute("System.ServiceModel", "4.0.0.0")]
    [System.ComponentModel.EditorBrowsableAttribute(System.ComponentModel.EditorBrowsableState.Advanced)]
    [System.ServiceModel.MessageContractAttribute(IsWrapped = false)]
    public partial class getSupportedCodeSystemsRequest
    {

        [System.ServiceModel.MessageBodyMemberAttribute(Name = "getSupportedCodeSystems", Namespace = "urn://hl7.org/CTSVAPI", Order = 0)]
        public getSupportedCodeSystemsRequestBody Body;

        public getSupportedCodeSystemsRequest()
        {
        }

        public getSupportedCodeSystemsRequest(getSupportedCodeSystemsRequestBody Body)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                this.Body = Body;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }

    [System.Diagnostics.DebuggerStepThroughAttribute()]
    [System.CodeDom.Compiler.GeneratedCodeAttribute("System.ServiceModel", "4.0.0.0")]
    [System.ComponentModel.EditorBrowsableAttribute(System.ComponentModel.EditorBrowsableState.Advanced)]
    [System.Runtime.Serialization.DataContractAttribute(Namespace = "urn://hl7.org/CTSVAPI")]
    public partial class getSupportedCodeSystemsRequestBody
    {

        [System.Runtime.Serialization.DataMemberAttribute(Order = 0)]
        public int timeout;

        [System.Runtime.Serialization.DataMemberAttribute(Order = 1)]
        public int sizeLimit;

        public getSupportedCodeSystemsRequestBody()
        {
        }

        public getSupportedCodeSystemsRequestBody(int timeout, int sizeLimit)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                this.timeout = timeout;
                this.sizeLimit = sizeLimit;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }

    [System.Diagnostics.DebuggerStepThroughAttribute()]
    [System.CodeDom.Compiler.GeneratedCodeAttribute("System.ServiceModel", "4.0.0.0")]
    [System.ComponentModel.EditorBrowsableAttribute(System.ComponentModel.EditorBrowsableState.Advanced)]
    [System.ServiceModel.MessageContractAttribute(IsWrapped = false)]
    public partial class getSupportedCodeSystemsResponse
    {

        [System.ServiceModel.MessageBodyMemberAttribute(Name = "getSupportedCodeSystemsResponse", Namespace = "urn://hl7.org/CTSVAPI", Order = 0)]
        public getSupportedCodeSystemsResponseBody Body;

        public getSupportedCodeSystemsResponse()
        {
        }

        public getSupportedCodeSystemsResponse(getSupportedCodeSystemsResponseBody Body)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                this.Body = Body;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }

    [System.Diagnostics.DebuggerStepThroughAttribute()]
    [System.CodeDom.Compiler.GeneratedCodeAttribute("System.ServiceModel", "4.0.0.0")]
    [System.ComponentModel.EditorBrowsableAttribute(System.ComponentModel.EditorBrowsableState.Advanced)]
    [System.Runtime.Serialization.DataContractAttribute(Namespace = "urn://hl7.org/CTSVAPI")]
    public partial class getSupportedCodeSystemsResponseBody
    {

        [System.Runtime.Serialization.DataMemberAttribute(EmitDefaultValue = false, Order = 0)]
        public CodeSystemIdAndVersions[] getSupportedCodeSystemsReturn;

        public getSupportedCodeSystemsResponseBody()
        {
        }

        public getSupportedCodeSystemsResponseBody(CodeSystemIdAndVersions[] getSupportedCodeSystemsReturn)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                this.getSupportedCodeSystemsReturn = getSupportedCodeSystemsReturn;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }

    [System.Diagnostics.DebuggerStepThroughAttribute()]
    [System.CodeDom.Compiler.GeneratedCodeAttribute("System.ServiceModel", "4.0.0.0")]
    [System.ComponentModel.EditorBrowsableAttribute(System.ComponentModel.EditorBrowsableState.Advanced)]
    [System.ServiceModel.MessageContractAttribute(IsWrapped = false)]
    public partial class lookupCodeSystemInfoRequest
    {

        [System.ServiceModel.MessageBodyMemberAttribute(Name = "lookupCodeSystemInfo", Namespace = "urn://hl7.org/CTSVAPI", Order = 0)]
        public lookupCodeSystemInfoRequestBody Body;

        public lookupCodeSystemInfoRequest()
        {
        }

        public lookupCodeSystemInfoRequest(lookupCodeSystemInfoRequestBody Body)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                this.Body = Body;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }

    [System.Diagnostics.DebuggerStepThroughAttribute()]
    [System.CodeDom.Compiler.GeneratedCodeAttribute("System.ServiceModel", "4.0.0.0")]
    [System.ComponentModel.EditorBrowsableAttribute(System.ComponentModel.EditorBrowsableState.Advanced)]
    [System.Runtime.Serialization.DataContractAttribute(Namespace = "urn://hl7.org/CTSVAPI")]
    public partial class lookupCodeSystemInfoRequestBody
    {

        [System.Runtime.Serialization.DataMemberAttribute(EmitDefaultValue = false, Order = 0)]
        public string codeSystem_id;

        [System.Runtime.Serialization.DataMemberAttribute(EmitDefaultValue = false, Order = 1)]
        public string codeSystem_name;

        public lookupCodeSystemInfoRequestBody()
        {
        }

        public lookupCodeSystemInfoRequestBody(string codeSystem_id, string codeSystem_name)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                this.codeSystem_id = codeSystem_id;
                this.codeSystem_name = codeSystem_name;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }

    [System.Diagnostics.DebuggerStepThroughAttribute()]
    [System.CodeDom.Compiler.GeneratedCodeAttribute("System.ServiceModel", "4.0.0.0")]
    [System.ComponentModel.EditorBrowsableAttribute(System.ComponentModel.EditorBrowsableState.Advanced)]
    [System.ServiceModel.MessageContractAttribute(IsWrapped = false)]
    public partial class lookupCodeSystemInfoResponse
    {

        [System.ServiceModel.MessageBodyMemberAttribute(Name = "lookupCodeSystemInfoResponse", Namespace = "urn://hl7.org/CTSVAPI", Order = 0)]
        public lookupCodeSystemInfoResponseBody Body;

        public lookupCodeSystemInfoResponse()
        {
        }

        public lookupCodeSystemInfoResponse(lookupCodeSystemInfoResponseBody Body)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                this.Body = Body;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }

    [System.Diagnostics.DebuggerStepThroughAttribute()]
    [System.CodeDom.Compiler.GeneratedCodeAttribute("System.ServiceModel", "4.0.0.0")]
    [System.ComponentModel.EditorBrowsableAttribute(System.ComponentModel.EditorBrowsableState.Advanced)]
    [System.Runtime.Serialization.DataContractAttribute(Namespace = "urn://hl7.org/CTSVAPI")]
    public partial class lookupCodeSystemInfoResponseBody
    {

        [System.Runtime.Serialization.DataMemberAttribute(EmitDefaultValue = false, Order = 0)]
        public CodeSystemInfo lookupCodeSystemInfoReturn;

        public lookupCodeSystemInfoResponseBody()
        {
        }

        public lookupCodeSystemInfoResponseBody(CodeSystemInfo lookupCodeSystemInfoReturn)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                this.lookupCodeSystemInfoReturn = lookupCodeSystemInfoReturn;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }

    [System.CodeDom.Compiler.GeneratedCodeAttribute("System.ServiceModel", "4.0.0.0")]
    [System.ServiceModel.ServiceContractAttribute(Namespace = "urn://hl7.org/CTSVAPI", ConfigurationName = "InfoWorld.EVS.CTSVAPI.RuntimeOperations")]
    public interface RuntimeOperations
    {

        // CODEGEN: Generating message contract since element name codeSystem_id from namespace urn://hl7.org/CTSVAPI is not marked nillable
        [System.ServiceModel.OperationContractAttribute(Action = "urn://hl7.org/CTSVAPI/RuntimeOperations/lookupCodeSystemInfo", ReplyAction = "urn://hl7.org/CTSVAPI/RuntimeOperations/lookupCodeSystemInfoResponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnknownCodeSystem), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnknownCodeSystem")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnexpectedError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedError")]
        [System.ServiceModel.FaultContractAttribute(typeof(CodeSystemNameIdMismatch), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "CodeSystemNameIdMismatch")]
        lookupCodeSystemInfoResponse lookupCodeSystemInfo(lookupCodeSystemInfoRequest request);

        // CODEGEN: Generating message contract since element name getSupportedCodeSystemsReturn from namespace urn://hl7.org/CTSVAPI is not marked nillable
        [System.ServiceModel.OperationContractAttribute(Action = "urn://hl7.org/CTSVAPI/RuntimeOperations/getSupportedCodeSystems", ReplyAction = "urn://hl7.org/CTSVAPI/RuntimeOperations/getSupportedCodeSystemsResponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnexpectedError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedError")]
        [System.ServiceModel.FaultContractAttribute(typeof(TimeoutError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "TimeoutError")]
        getSupportedCodeSystemsResponse getSupportedCodeSystems(getSupportedCodeSystemsRequest request);

        [System.ServiceModel.OperationContractAttribute(Action = "urn://hl7.org/CTSVAPI/RuntimeOperations/isConceptIdValid", ReplyAction = "urn://hl7.org/CTSVAPI/RuntimeOperations/isConceptIdValidResponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnexpectedError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedError")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnknownCodeSystem), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnknownCodeSystem")]
        [return: System.ServiceModel.MessageParameterAttribute(Name = "isConceptIdValidReturn")]
        bool isConceptIdValid(ConceptId concept_id, bool activeConceptsOnly);

        [System.ServiceModel.OperationContractAttribute(Action = "urn://hl7.org/CTSVAPI/RuntimeOperations/lookupDesignation", ReplyAction = "urn://hl7.org/CTSVAPI/RuntimeOperations/lookupDesignationResponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnexpectedError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedError")]
        [System.ServiceModel.FaultContractAttribute(typeof(NoApplicableDesignationFound), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "NoApplicableDesignationFound")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnknownLanguageCode), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnknownLanguageCode")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnknownConceptCode), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnknownConceptCode")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnknownCodeSystem), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnknownCodeSystem")]
        [return: System.ServiceModel.MessageParameterAttribute(Name = "lookupDesignationReturn")]
        StringAndLanguage lookupDesignation(ConceptId concept_id, string language_code);

        [System.ServiceModel.OperationContractAttribute(Action = "urn://hl7.org/CTSVAPI/RuntimeOperations/areCodesRelated", ReplyAction = "urn://hl7.org/CTSVAPI/RuntimeOperations/areCodesRelatedResponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnknownRelationshipCode), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnknownRelationshipCode")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnknownCodeSystem), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnknownCodeSystem")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnexpectedError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedError")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnknownRelationQualifier), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnknownRelationQualifier")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnknownConceptCode), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnknownConceptCode")]
        [return: System.ServiceModel.MessageParameterAttribute(Name = "areCodesRelatedReturn")]
        bool areCodesRelated(string codeSystem_id, string source_code, string target_code, string relationship_code, string[] relationQualifiers, bool directRelationsOnly);

        [System.ServiceModel.OperationContractAttribute(Action = "urn://hl7.org/CTSVAPI/RuntimeOperations/getServiceName", ReplyAction = "urn://hl7.org/CTSVAPI/RuntimeOperations/getServiceNameResponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnexpectedError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedError")]
        [return: System.ServiceModel.MessageParameterAttribute(Name = "getServiceNameReturn")]
        string getServiceName();

        [System.ServiceModel.OperationContractAttribute(Action = "urn://hl7.org/CTSVAPI/RuntimeOperations/getServiceVersion", ReplyAction = "urn://hl7.org/CTSVAPI/RuntimeOperations/getServiceVersionResponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnexpectedError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedError")]
        [return: System.ServiceModel.MessageParameterAttribute(Name = "getServiceVersionReturn")]
        string getServiceVersion();

        [System.ServiceModel.OperationContractAttribute(Action = "urn://hl7.org/CTSVAPI/RuntimeOperations/getCTSVersion", ReplyAction = "urn://hl7.org/CTSVAPI/RuntimeOperations/getCTSVersionResponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnexpectedError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedError")]
        [return: System.ServiceModel.MessageParameterAttribute(Name = "getCTSVersionReturn")]
        CTSVersionId getCTSVersion();

        [System.ServiceModel.OperationContractAttribute(Action = "urn://hl7.org/CTSVAPI/RuntimeOperations/getServiceDescription", ReplyAction = "urn://hl7.org/CTSVAPI/RuntimeOperations/getServiceDescriptionResponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnexpectedError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedError")]
        [return: System.ServiceModel.MessageParameterAttribute(Name = "getServiceDescriptionReturn")]
        string getServiceDescription();
    }
    [System.CodeDom.Compiler.GeneratedCodeAttribute("System.ServiceModel", "4.0.0.0")]
    public interface RuntimeOperationsChannel : RuntimeOperations, System.ServiceModel.IClientChannel
    {
    }

    [System.Diagnostics.DebuggerStepThroughAttribute()]
    [System.CodeDom.Compiler.GeneratedCodeAttribute("System.ServiceModel", "4.0.0.0")]
    public partial class RuntimeOperationsClient : System.ServiceModel.ClientBase<RuntimeOperations>, RuntimeOperations, IDisposable
    {
        #region ProxyTool Generated Code

        private RuntimeOperationsClient _instance;
        private string _endpointConfigurationName;
        private string _remoteAddress;
        private System.ServiceModel.EndpointAddress _endpointAddress;
        private System.ServiceModel.Channels.Binding _binding;

        private void InitProxyInstance()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    if (_instance != null)
                        if (_instance.State != System.ServiceModel.CommunicationState.Faulted)
                            _instance.Close();
                        else
                            _instance.Abort();
                }
                catch { }

                if (_binding != null)
                    _instance = new RuntimeOperationsClient(_binding, _endpointAddress);
                else if (_endpointAddress != null)
                    _instance = new RuntimeOperationsClient(_endpointConfigurationName, _endpointAddress);
                else if (_remoteAddress != null)
                    _instance = new RuntimeOperationsClient(_endpointConfigurationName, _remoteAddress);
                else if (_endpointConfigurationName != null)
                    _instance = new RuntimeOperationsClient(_endpointConfigurationName);
                else
                    _instance = new RuntimeOperationsClient();
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        void System.IDisposable.Dispose()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                this.Close();
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public new void Close()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    if (_instance != null)
                        ((System.ServiceModel.ClientBase<RuntimeOperations>)_instance).Close();
                    if (_instance != this)
                        ((System.ServiceModel.ClientBase<RuntimeOperations>)this).Close();
                }
                catch { }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public new void Abort()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    if (_instance != null)
                        ((System.ServiceModel.ClientBase<RuntimeOperations>)_instance).Abort();
                    if (_instance != this)
                        ((System.ServiceModel.ClientBase<RuntimeOperations>)this).Abort();
                }
                catch { }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        #endregion

        public RuntimeOperationsClient()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                _instance = this;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public RuntimeOperationsClient(string endpointConfigurationName) : base(endpointConfigurationName)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                _instance = this;
                _endpointConfigurationName = endpointConfigurationName;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public RuntimeOperationsClient(string endpointConfigurationName, string remoteAddress) : base(endpointConfigurationName, remoteAddress)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                _instance = this;
                _endpointConfigurationName = endpointConfigurationName;
                _remoteAddress = remoteAddress;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public RuntimeOperationsClient(string endpointConfigurationName, System.ServiceModel.EndpointAddress remoteAddress) : base(endpointConfigurationName, remoteAddress)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                _instance = this;
                _endpointConfigurationName = endpointConfigurationName;
                _endpointAddress = remoteAddress;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public RuntimeOperationsClient(System.ServiceModel.Channels.Binding binding, System.ServiceModel.EndpointAddress remoteAddress) : base(binding, remoteAddress)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                _instance = this;
                _binding = binding;
                _endpointAddress = remoteAddress;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        [System.ComponentModel.EditorBrowsableAttribute(System.ComponentModel.EditorBrowsableState.Advanced)]
        lookupCodeSystemInfoResponse RuntimeOperations.lookupCodeSystemInfo(lookupCodeSystemInfoRequest request)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.lookupCodeSystemInfo(request);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.lookupCodeSystemInfo(request);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<RuntimeOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public CodeSystemInfo lookupCodeSystemInfo(string codeSystem_id, string codeSystem_name)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                lookupCodeSystemInfoRequest inValue = new lookupCodeSystemInfoRequest();
                inValue.Body = new lookupCodeSystemInfoRequestBody();
                inValue.Body.codeSystem_id = codeSystem_id;
                inValue.Body.codeSystem_name = codeSystem_name;
                lookupCodeSystemInfoResponse retVal = null;
                try
                {
                    retVal = _instance.Channel.lookupCodeSystemInfo(inValue);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        retVal = _instance.Channel.lookupCodeSystemInfo(inValue);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<RuntimeOperationsClient>(_instance, _endpointConfigurationName);
                }
                return retVal.Body.lookupCodeSystemInfoReturn;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        [System.ComponentModel.EditorBrowsableAttribute(System.ComponentModel.EditorBrowsableState.Advanced)]
        getSupportedCodeSystemsResponse RuntimeOperations.getSupportedCodeSystems(getSupportedCodeSystemsRequest request)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.getSupportedCodeSystems(request);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.getSupportedCodeSystems(request);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<RuntimeOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public CodeSystemIdAndVersions[] getSupportedCodeSystems(int timeout, int sizeLimit)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                getSupportedCodeSystemsRequest inValue = new getSupportedCodeSystemsRequest();
                inValue.Body = new getSupportedCodeSystemsRequestBody();
                inValue.Body.timeout = timeout;
                inValue.Body.sizeLimit = sizeLimit;
                getSupportedCodeSystemsResponse retVal = null;
                try
                {
                    retVal = _instance.Channel.getSupportedCodeSystems(inValue);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        retVal = _instance.Channel.getSupportedCodeSystems(inValue);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<RuntimeOperationsClient>(_instance, _endpointConfigurationName);
                }
                return retVal.Body.getSupportedCodeSystemsReturn;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public bool isConceptIdValid(ConceptId concept_id, bool activeConceptsOnly)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.isConceptIdValid(concept_id, activeConceptsOnly);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.isConceptIdValid(concept_id, activeConceptsOnly);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<RuntimeOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public StringAndLanguage lookupDesignation(ConceptId concept_id, string language_code)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.lookupDesignation(concept_id, language_code);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.lookupDesignation(concept_id, language_code);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<RuntimeOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public bool areCodesRelated(string codeSystem_id, string source_code, string target_code, string relationship_code, string[] relationQualifiers, bool directRelationsOnly)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.areCodesRelated(codeSystem_id, source_code, target_code, relationship_code, relationQualifiers, directRelationsOnly);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.areCodesRelated(codeSystem_id, source_code, target_code, relationship_code, relationQualifiers, directRelationsOnly);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<RuntimeOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public string getServiceName()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.getServiceName();
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.getServiceName();
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<RuntimeOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public string getServiceVersion()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.getServiceVersion();
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.getServiceVersion();
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<RuntimeOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public CTSVersionId getCTSVersion()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.getCTSVersion();
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.getCTSVersion();
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<RuntimeOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public string getServiceDescription()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.getServiceDescription();
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.getServiceDescription();
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<RuntimeOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
