﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.Utils;
using BMS.ServiceContracts;
using BMS.DataContracts;

namespace BMS.ServicesWrapper.Proxy
{

    [System.CodeDom.Compiler.GeneratedCodeAttribute("System.ServiceModel", "4.0.0.0")]
    public interface VistaQueryChannel : IVistaWorkerQuery, System.ServiceModel.IClientChannel
    {
    }

    [System.Diagnostics.DebuggerStepThroughAttribute()]
    [System.CodeDom.Compiler.GeneratedCodeAttribute("System.ServiceModel", "4.0.0.0")]
    public partial class VistaQueryClient : System.ServiceModel.ClientBase<IVistaWorkerQuery>, IVistaWorkerQuery, System.IDisposable
    {
        #region ProxyTool Generated Code

        private VistaQueryClient _instance;
        private string _endpointConfigurationName;
        private string _remoteAddress;
        private System.ServiceModel.EndpointAddress _endpointAddress;
        private System.ServiceModel.Channels.Binding _binding;

        private void InitProxyInstance()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    if (_instance != null)
                        if (_instance.State != System.ServiceModel.CommunicationState.Faulted)
                            _instance.Close();
                        else
                            _instance.Abort();
                }
                catch { }

                if (_binding != null)
                    _instance = new VistaQueryClient(_binding, _endpointAddress);
                else if (_endpointAddress != null)
                    _instance = new VistaQueryClient(_endpointConfigurationName, _endpointAddress);
                else if (_remoteAddress != null)
                    _instance = new VistaQueryClient(_endpointConfigurationName, _remoteAddress);
                else if (_endpointConfigurationName != null)
                    _instance = new VistaQueryClient(_endpointConfigurationName);
                else
                    _instance = new VistaQueryClient();
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        void System.IDisposable.Dispose()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                this.Close();
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public new void Close()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    if (_instance != null)
                        ((System.ServiceModel.ClientBase<IVistaWorkerQuery>)_instance).Close();
                    if (_instance != this)
                        ((System.ServiceModel.ClientBase<IVistaWorkerQuery>)this).Close();
                }
                catch { }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public new void Abort()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    if (_instance != null)
                        ((System.ServiceModel.ClientBase<IVistaWorkerQuery>)_instance).Abort();
                    if (_instance != this)
                        ((System.ServiceModel.ClientBase<IVistaWorkerQuery>)this).Abort();
                }
                catch { }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        #endregion

        public VistaQueryClient()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                _instance = this;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public VistaQueryClient(string endpointConfigurationName) : base(endpointConfigurationName)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                _instance = this;
                _endpointConfigurationName = endpointConfigurationName;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public VistaQueryClient(string endpointConfigurationName, string remoteAddress) : base(endpointConfigurationName, remoteAddress)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                _instance = this;
                _endpointConfigurationName = endpointConfigurationName;
                _remoteAddress = remoteAddress;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public VistaQueryClient(string endpointConfigurationName, System.ServiceModel.EndpointAddress remoteAddress) : base(endpointConfigurationName, remoteAddress)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                _instance = this;
                _endpointConfigurationName = endpointConfigurationName;
                _endpointAddress = remoteAddress;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public VistaQueryClient(System.ServiceModel.Channels.Binding binding, System.ServiceModel.EndpointAddress remoteAddress) : base(binding, remoteAddress)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                _instance = this;
                _binding = binding;
                _endpointAddress = remoteAddress;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }                

        public void RunOnDemand(DataContracts.VistASite site, VistaDataType types, DateTime? startDate, DateTime? endDate, DataRetrievalMethod retrievalMethod)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    _instance.Channel.RunOnDemand(site, types, startDate, endDate, retrievalMethod);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        _instance.Channel.RunOnDemand(site, types, startDate, endDate, retrievalMethod);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<VistaQueryClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }


        public void TestConnection(DataContracts.VistASite site, DataRetrievalMethod retrievalMethod)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    _instance.Channel.TestConnection(site, retrievalMethod);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        _instance.Channel.TestConnection(site, retrievalMethod);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<VistaQueryClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void SetRefreshSchedulersFlag()
        {
            try
            {
                _instance.Channel.SetRefreshSchedulersFlag();
            }
            catch (System.Exception e)
            {
                if (!ProxyManager.CheckThrownException(e))
                    throw;
                else
                {
                    InitProxyInstance();
                    _instance.Channel.SetRefreshSchedulersFlag();
                }
            }
            finally
            {
                ProxyManager.ReturnProxy<VistaQueryClient>(_instance, _endpointConfigurationName);
            }
        }

        public void SetRefreshVistACommandsFlag()
        {
            try
            {
                _instance.Channel.SetRefreshVistACommandsFlag();
            }
            catch (System.Exception e)
            {
                if (!ProxyManager.CheckThrownException(e))
                    throw;
                else
                {
                    InitProxyInstance();
                    _instance.Channel.SetRefreshVistACommandsFlag();
                }
            }
            finally
            {
                ProxyManager.ReturnProxy<VistaQueryClient>(_instance, _endpointConfigurationName);
            }
        }

        public void SetRefreshNumiCommandsFlag()
        {
            try
            {
                _instance.Channel.SetRefreshNumiCommandsFlag();
            }
            catch (System.Exception e)
            {
                if (!ProxyManager.CheckThrownException(e))
                    throw;
                else
                {
                    InitProxyInstance();
                    _instance.Channel.SetRefreshNumiCommandsFlag();
                }
            }
            finally
            {
                ProxyManager.ReturnProxy<VistaQueryClient>(_instance, _endpointConfigurationName);
            }
        }

        public void SetRefreshWhiteboardReportCommandsFlag()
        {
            try
            {
                _instance.Channel.SetRefreshWhiteboardReportCommandsFlag();
            }
            catch (System.Exception e)
            {
                if (!ProxyManager.CheckThrownException(e))
                    throw;
                else
                {
                    InitProxyInstance();
                    _instance.Channel.SetRefreshWhiteboardReportCommandsFlag();
                }
            }
            finally
            {
                ProxyManager.ReturnProxy<VistaQueryClient>(_instance, _endpointConfigurationName);
            }
        }

        public void RefreshSchedulers()
        {     
            try
            {
                _instance.Channel.RefreshSchedulers();
            }
            catch (System.Exception e)
            {
                if (!ProxyManager.CheckThrownException(e))
                    throw;
                else
                {
                    InitProxyInstance();
                    _instance.Channel.RefreshSchedulers();
                }
            }
            finally
            {
                ProxyManager.ReturnProxy<VistaQueryClient>(_instance, _endpointConfigurationName);
            }
        }

        public void RefreshVistACommands()
        {
            try
            {
                _instance.Channel.RefreshVistACommands();
            }
            catch (System.Exception e)
            {
                if (!ProxyManager.CheckThrownException(e))
                    throw;
                else
                {
                    InitProxyInstance();
                    _instance.Channel.RefreshVistACommands();
                }
            }
            finally
            {
                ProxyManager.ReturnProxy<VistaQueryClient>(_instance, _endpointConfigurationName);
            }
        }

        public void RefreshNumiCommands()
        {
            try
            {
                _instance.Channel.RefreshNumiCommands();
            }
            catch (System.Exception e)
            {
                if (!ProxyManager.CheckThrownException(e))
                    throw;
                else
                {
                    InitProxyInstance();
                    _instance.Channel.RefreshNumiCommands();
                }
            }
            finally
            {
                ProxyManager.ReturnProxy<VistaQueryClient>(_instance, _endpointConfigurationName);
            }
        }

        public void RefreshWhiteboardReportCommands()
        {
            try
            {
                _instance.Channel.RefreshWhiteboardReportCommands();
            }
            catch (System.Exception e)
            {
                if (!ProxyManager.CheckThrownException(e))
                    throw;
                else
                {
                    InitProxyInstance();
                    _instance.Channel.RefreshWhiteboardReportCommands();
                }
            }
            finally
            {
                ProxyManager.ReturnProxy<VistaQueryClient>(_instance, _endpointConfigurationName);
            }
        }
    }
}
