﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.ServicesWrapper.Proxy;
using BMS.Utils;

namespace BMS.ServicesWrapper.BMService
{
    /// <summary>
    /// BMS factory class responsible for BMS proxy accessing.
    /// </summary>
    public class BMSFactory
    {
        /// <summary>
        /// Access to the BMS Configuration Operations WCF proxy.
        /// </summary>
        public static ConfigurationOperationsClient ConfigurationOperationsClient
        {
            get { return ProxyManager.GetProxy<ConfigurationOperationsClient>("BMS.BMSConfigurationOperations"); }
        }

        /// <summary>
        /// Access to the BMS Configuration Operations WCF proxy using windows credentials.
        /// </summary>
        public static ConfigurationOperationsClient ConfigurationOperationsClientWindows
        {
            get { return ProxyManager.GetProxy<ConfigurationOperationsClient>("BMS.BMSConfigurationOperations.Windows"); }
        }

        /// <summary>
        /// Access to the BMS query client WCF proxy.
        /// </summary>
        public static BedManagerQueryClient BedManagerQueryClient
        {
            get { return ProxyManager.GetProxy<BedManagerQueryClient>("BMS.BMSQuery"); }
        }

        /// <summary>
        /// Access to the BMS query client WCF proxy using Windows authentication.
        /// </summary>
        public static BedManagerQueryClient BedManagerQueryClientWindows
        {
            get { return ProxyManager.GetProxy<BedManagerQueryClient>("BMS.BMSQuery.Windows"); }
        }

        /// <summary>
        /// The client instance used by calls from WCF/WF that use the DurableIssuedTokenClientCredentials
        /// if there is a current SessionID or the windows instance otherwise.
        /// </summary>
        public static BedManagerQueryClient BedManagerQueryClientFromWCF
        {
            get
            {
                if (!String.IsNullOrEmpty(ProxyManager.GetCurrentSessionID()))
                    return BedManagerQueryClient;
                else
                    return BedManagerQueryClientWindows;
            }
        }

        /// <summary>
        /// Access to the BMS operations client WCF proxy.
        /// </summary>
        public static BedManagerOperationsClient BedManagerOperationsClient
        {
            get { return ProxyManager.GetProxy<BedManagerOperationsClient>("BMS.BMSOperations"); }
        }

        /// <summary>
        /// Access to the BMS operations client WCF proxy using Windows authentication.
        /// </summary>
        public static BedManagerOperationsClient BedManagerOperationsClientWindows
        {
            get { return ProxyManager.GetProxy<BedManagerOperationsClient>("BMS.BMSOperations.Windows"); }
        }

        /// <summary>
        /// The client instance used by calls from WCF/WF that use the DurableIssuedTokenClientCredentials
        /// if there is a current SessionID or the windows instance otherwise.
        /// </summary>
        public static BedManagerOperationsClient BedManagerOperationsClientFromWCF
        {
            get
            {
                if (!String.IsNullOrEmpty(ProxyManager.GetCurrentSessionID()))
                    return BedManagerOperationsClient;
                else
                    return BedManagerOperationsClientWindows;
            }
        }
        /// <summary>
        /// The client instance used by calls from WCF/WF that use the DurableIssuedTokenClientCredentials
        /// if there is a current SessionID or the windows instance otherwise.
        /// </summary>
        public static ConfigurationOperationsClient ConfigurationOperationsClientFromWCF
        {
            get
            {
                if (!String.IsNullOrEmpty(ProxyManager.GetCurrentSessionID()))
                    return ConfigurationOperationsClient;
                else
                    return ConfigurationOperationsClientWindows;
            }
        }

        /// <summary>
        /// Access to the Vista Query WCF proxy using windows credentials.
        /// </summary>
        public static VistaQueryClient VistaQueryClientWindows
        {
            get { return ProxyManager.GetProxy<VistaQueryClient>("BMS.VistaQuery.Windows"); }
        }

        /// <summary>
        /// Access to the Vista Query WCF proxy.
        /// </summary>
        public static VistaQueryClient VistaQueryClient
        {
            get { return ProxyManager.GetProxy<VistaQueryClient>("BMS.VistaQuery"); }
        }

        /// <summary>
        /// Access to the BMS Cache WCF proxy using windows credentials.
        /// </summary>
        public static BMSCacheOperationsClient BMSCacheOperationsClientWindows
        {
            get { return ProxyManager.GetProxy<BMSCacheOperationsClient>("BMS.Cache.Windows"); }
        }

        /// <summary>
        /// Access to the BMS Cache SSL WCF proxy using windows credentials.
        /// </summary>
        public static BMSCacheOperationsClient BMSCacheOperationsClientWindowsSsl
        {
            get { return ProxyManager.GetProxy<BMSCacheOperationsClient>("BMS.Cache.Windows.Https"); }
        }

        /// <summary>
        /// Access to the BMS Cache WCF proxy using windows credentials.
        /// </summary>
        public static BedManagerCacheClient BedManagerCacheClientWindows
        {
            get { return ProxyManager.GetProxy<BedManagerCacheClient>("BMS.BMSCache.Windows"); }
        }

        /// <summary>
        /// Access to the BMS Cache WCF proxy.
        /// </summary>
        public static BedManagerCacheClient BedManagerCacheClient
        {
            get { return ProxyManager.GetProxy<BedManagerCacheClient>("BMS.BMSCache"); }
        }

        /// <summary>
        /// The client instance used by calls from WCF/WF that use the DurableIssuedTokenClientCredentials
        /// if there is a current SessionID or the windows instance otherwise.
        /// </summary>
        public static BedManagerCacheClient BedManagerCacheClientFromWCF
        {
            get
            {
                if (!String.IsNullOrEmpty(ProxyManager.GetCurrentSessionID()))
                    return BedManagerCacheClient;
                else
                    return BedManagerCacheClientWindows;
            }
        }

        /// <summary>
        /// Access to the NUMI Web Service proxy.
        /// </summary>
        public static InpatientSoapClient InpatientSoapClientWindows
        {
            get { return ProxyManager.GetProxy<InpatientSoapClient>("InpatientSoap"); }
        }

        /// <summary>
        /// Gets the reporting service client.
        /// </summary>
        public static ReportingServiceClient ReportingServiceClient
        {
            get { return ProxyManager.GetProxy<ReportingServiceClient>("BMS.ReportingService"); }
        }
    }
}
