﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Activities;
using System.ServiceModel;
using BMS.Facade.Fault;
using BMS.Utils.Properties;

namespace BMS.Workflows.CustomActivities.Utils
{
    public class HandleInvalidOperationFault : CodeActivity
    {
        public InArgument<string> OperationName { get; set; }
        public InArgument<string> SourceStateName { get; set; }
        public InArgument<string> ErrorMessage { get; set; }
        public OutArgument<FaultException<GenericWFServiceFault>> FaultResult { get; set; }

        protected override void Execute(CodeActivityContext context)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                WFInvalidOperation exc = new WFInvalidOperation()
                {
                    OperationName = this.OperationName.Get<string>(context),
                    SourceStateName = this.SourceStateName.Get<string>(context),
                    FriendlyMessage = this.ErrorMessage.Get<string>(context)
                };

                this.FaultResult.Set(context, new FaultException<GenericWFServiceFault>(new GenericWFServiceFault() { ServiceFault = exc }));
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
