﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaIntegration.Data;
using SC = BMS.DataContracts;
using FC = BMS.Facade.Data;
using BMS.ServicesWrapper.WF;
using BMS.Utils;
using InfoWorld.HL7.ITS;
using System.ServiceModel;
using BMS.Facade.Fault;
using BMS.ServicesWrapper.BMService;
using BMS.DataContracts;
using BMS.FaultContracts;

namespace BMS.VistaWorker2.Writer.Implementation.Concrete.WF
{
    /// <summary>
    /// The patient appointment writer.
    /// </summary>
    class PatientAppointmentWriter : BaseWorkFlowWriter<PatientAppointment>
    {
        List<SC.HospitalLocationAppointment> assignedHLList = new List<HospitalLocationAppointment>();

        private SC.DischargeAppointment Translate(PatientAppointment entity)
        {
            SC.DischargeAppointment wfDischarge = null;
            string domainId = BMS.ServicesWrapper.Security.SecurityFactory.InstanceWindows.GetCurrentDomain();
            FC.HospitalLocation hospitalLocation = InsertIfNullOrUpdateIfDirty<BMS.VistaIntegration.Data.HospitalLocation, FC.HospitalLocation>(entity.HospitalLocation);
            if (assignedHLList.Where(a => a.HospitalLocationId.extension.Equals(hospitalLocation.Id.extension, StringComparison.InvariantCultureIgnoreCase)).FirstOrDefault() != null)
            {                
                wfDischarge = new SC.DischargeAppointment()
                {
                    Id = new II(domainId, null),
                    IsActive = (string.IsNullOrEmpty(entity.CurrentStatus) || 
                                        (entity.CurrentStatus.Equals("CANCELLED", StringComparison.InvariantCultureIgnoreCase)
                                        || entity.CurrentStatus.Equals("DISCONTINUED", StringComparison.InvariantCultureIgnoreCase)
                                        || entity.CurrentStatus.Equals("COMPLETE", StringComparison.InvariantCultureIgnoreCase))) ? false : true,
                    AppointmentDate = entity.AppointmentDateTime,
                    Status = entity.CurrentStatus,
                    EnteredDate = (entity.DateAppointmentMade.HasValue) ? entity.DateAppointmentMade.Value : DateTime.UtcNow,
                    PatientId = MakePatient(entity.Patient),
                    HospitalLocationId = (hospitalLocation != null) ? hospitalLocation.Id : null,
                    VistaSiteId = (VistaSite != null) ? VistaSite.Id : null
                };
                ConvertToUtc(wfDischarge);
            }
            return wfDischarge;
        }

        /// <summary>
        /// Sends the event.
        /// </summary>
        /// <param name="entity">The entity.</param>
        protected override bool SendEvent(PatientAppointment entity)
        {
            if (assignedHLList == null || assignedHLList.Count == 0)
                assignedHLList = BMSFactory.BedManagerOperationsClientWindows.GetHospitalLocationsAppointment(null, Guid.Parse(VistaSite.Id.extension));
            SC.DischargeAppointment wfDischarge = Translate(entity);
            if (wfDischarge != null)
            {
                AdmissionEvent admission = null;
                try
                {
                    DateTime dt = DateTime.SpecifyKind(wfDischarge.AppointmentDate.Value, DateTimeKind.Unspecified);
                    admission = BMSFactory.BedManagerOperationsClientWindows.GetAdmissionEventForPatient(wfDischarge.PatientId, VistaSite.Id, null, TimeZoneInfo.ConvertTimeToUtc(dt, VistATimeZone));
                }                            
                catch (FaultException<EntityNotFoundException>) { }
                wfDischarge.WardId = admission != null ? admission.WardId : null;
                BMS.ServicesWrapper.BMService.BMSFactory.BedManagerOperationsClientWindows.CreateDischargeAppointment(wfDischarge);
                entity.PatientId = wfDischarge.PatientId.extension;
                UtilsInstance.SendMailNotification(entity, wfDischarge.VistaSiteId, VistATimeZone, Constants.DISCHARGE_APPOINTMENT, admission, wfDischarge.PatientId);
                Logger.LogFormat(BmsLogger.Level.Info, "Create discharge intent for patient {0} with succes", entity.Patient.Name);
                return true;
            }
            else
            {
                Logger.LogFormat(BmsLogger.Level.Info, "Abort: Hospital Location {0} from PatientAppointment for patient {1} has not been added from BMS in Bed Board Discharge Appointment Clinic Configuration"
                   , entity.HospitalLocation.Name, entity.Patient.Name);
                return false;
            }
        }

        protected override SC.VistaIntegrationLog MakeLog(PatientAppointment entity)
        {
            return new SC.VistaIntegrationLog()
            {
                File = SC.VistaFiles.PatientAppointment,
                Ien = string.Format("{0}_{1}", entity.Patient.IEN, entity.AppointmentDateTime.ToString("MM/dd/yyyy HH:mm:ss"))
            };
        }
    }
}
