﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.Facade.Data;
using BMS.VistaWorker2.Writer.Implementation.Concrete.Dal;

namespace BMS.VistaWorker2.Writer.Implementation.Concrete.DalCached
{
    public class HospitalLocationCachedDal : BaseCachedDal<HospitalLocation>
    {
        public HospitalLocationCachedDal(IEntityDal<HospitalLocation> dal) : base(dal) { }

        protected override Dictionary<string, HospitalLocation> InitCache()
        {
            var hospitals = EIS.GetHospitalLocations(Site.Id);
            return hospitals.ToDictionary(s => s.Ien);
        }

    }
}
