﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using InfoWorld.HL7.ITS;
using BMS.ServicesWrapper.EVS;
using BMS.Facade.Data;
using BMS.VistaWorker2.Writer.Implementation.Concrete.Dal;

namespace BMS.VistaWorker2.Writer.Implementation.Concrete.DalCached
{
    public class GlobalEvsCachedDal : BaseCachedDal<CD>
    {
        private readonly string codeSystemName;

        public GlobalEvsCachedDal(GlobalEvsDal dal)
            : base(dal)
        {
            this.codeSystemName = dal.CodeSystemName;
        }

        protected override Dictionary<string, CD> InitCache()
        {
            if (codeSystemName.Equals(Util.Vocabulary.OrderableItem.ToString(), StringComparison.InvariantCultureIgnoreCase))
            {
                return EVS.SearchConceptsWithPaging(new CodeFilterParameters()
                {
                    VocabularyDomain = codeSystemName,
                    MaxSelectedCodes = int.MaxValue,
                    MatchAlgorithm = MatchAlgorithm.StartsWithIgnoreCase,
                    MatchProperty = MatchProperty.Code,
                    MatchText = Site.Code
                }).ToDictionary(s => s.code);
            }
            else
                return EVS.GetCodes(new CodeFilterParameters() { VocabularyDomain = codeSystemName, MaxSelectedCodes = int.MaxValue }).ToDictionary(s => s.code);
        }
    }
}
