﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.Facade.Data;
using BMS.VistaIntegration.Data;
using BMS.ServicesWrapper;

namespace BMS.VistaWorker2.Writer.Implementation.Concrete.Dal
{
    public class WardDal : BaseDal<Ward>
    {
        public WardDal(VistaSite site) : base(site) { }

        public override Ward Get(IEntity entity)
        {
            return EIS.GetWard(entity.IEN, Site.Id);
        }

        public override void Add(IEntity vistaEntity, Ward entity)
        {
            EIS_EVSLockWrapper.InsertWard(entity, Site.Code);
        }

        public override void Delete(IEntity vistaEntity, Ward entity)
        {
            EIS.DeleteWard(entity.Id);
        }

        public override void Update(IEntity vistaEntity, Ward entity)
        {
            EIS.UpdateWard(entity);
        }
    }
}
