﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.Facade.Data;
using BMS.ServicesWrapper;
using BMS.ServicesWrapper.EIS;
using InfoWorld.HL7.ITS;
using BMS.Utils;


namespace BMS.VistaWorker2.Writer.Implementation.Concrete.Dal
{
    public class PatientDal : IEntityDal<Patient>
    {
        public PatientDal(Facade.Data.VistaSite site)
        {
            Site = site;
        }

        public Facade.Data.VistaSite Site
        {
            get;
            private set;
        }

        public static IEISWrapper EIS { get { return EISFactory.InstanceWindows; } }

        public Patient Get(VistaIntegration.Data.IEntity vistaEntity)
        {
            BMS.VistaIntegration.Data.Patient vistaPatient = vistaEntity as BMS.VistaIntegration.Data.Patient;
            return EIS.GetPatientBySsn(new II() { root = Constants.SSNROOT, extension = vistaPatient.SocialSecurityNumber }, null);
        }

        public void Add(VistaIntegration.Data.IEntity vistaEntity, Patient entity)
        {
            EIS_EVSLockWrapper.InsertPatient(entity, Site.Code);
        }

        public void Delete(VistaIntegration.Data.IEntity vistaEntity, Patient entity)
        {
            EIS.DeletePatient(entity.Id);
        }

        public void Update(VistaIntegration.Data.IEntity vistaEntity, Patient entity)
        {
            EIS.UpdatePatient(entity);
        }
    }
}
