﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using InfoWorld.HL7.ITS;
using BMS.ServicesWrapper.EVS;
using BMS.VistaIntegration.Data;
using FC = BMS.Facade.Data;
using BMS.Utils;

namespace BMS.VistaWorker2.Writer.Implementation.Concrete
{
    abstract class BaseEvsWriter<T> : BaseEisWriter<T, CD>
        where T : class,IConcept
    {
        private readonly bool global;

        protected BaseEvsWriter(bool global = false)
        {
            this.global = global;
        }

        protected abstract string CodeSystem { get; }
        protected abstract string CodeSystemName { get; }
        private string GetIen(T concept) { return concept.IEN; }
        protected string GetName(T concept) { return concept.Name; }

        //private bool hasChanged = false;

        /// <summary>
        /// Translates the VistA entity to an existing EVS concept (for use in BMS).
        /// </summary>
        /// <param name="entity">The VistA entity.</param>
        /// <param name="concept">The EVS concept.</param>
        protected override void TranslateFromVistaToBMS(T entity, CD concept)
        {
            concept.code = GetIen(entity);
            if (!global) concept.code = WriterUtilities.MakeCDCode(VistaSite.Code, concept.code);
            concept.codeSystem = CodeSystem;
            concept.codeSystemName = CodeSystemName;
            concept.displayName = GetName(entity);
        }

        /// <summary>
        /// Inserts the BMS entity.
        /// </summary>
        /// <param name="concept">The concept.</param>
        protected override void InsertBmsEntity(T entity, CD concept)
        {
            base.InsertBmsEntity(entity, concept);
            //hasChanged = true;
        }

        /// <summary>
        /// Updates the BMS entity.
        /// </summary>
        /// <param name="concept">The concept.</param>
        protected override void UpdateBmsEntity(T entity, CD concept)
        {
            base.UpdateBmsEntity(entity, concept);
            //hasChanged = true;
        }

        /// <summary>
        /// Deletes the BMS entity.
        /// </summary>
        /// <param name="concept">The concept.</param>
        protected override void DeleteBmsEntity(T entity, CD concept)
        {
            base.DeleteBmsEntity(entity, concept);
            //hasChanged = true;
        }

        protected override bool AreFieldsEqual(T entity, CD bmsEntity)
        {
            string name = GetName(entity);
            return bmsEntity.displayName == name;
        }

        public override void Dispose()
        {
            //if (hasChanged)            
            //    EVS.ReloadVocabularyCache(CodeSystemName, VistaSite.Code);
        }
    }
}
