﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaWorker.Reader.Abstract;

namespace BMS.VistaWorker.Reader.Concrete.Entities
{
    /// <summary>
    /// Convertor from database specific char to enum action.
    /// </summary>
    internal static class TranslateCrudAction
    {
        /// <summary>
        /// Translate char to crud action enum.
        /// </summary>
        /// <param name="c"> Character.</param>
        /// <returns></returns>
        public static CrudAction ToEnum(char c)
        {
            if (c == 'I') return CrudAction.Insert;
            if (c == 'U') return CrudAction.Update;
            if (c == 'D') return CrudAction.Delete;
            return CrudAction.None;
        }

        /// <summary>
        /// Translate crud action enum to char.
        /// </summary>
        /// <param name="action">The crud action.</param>
        /// <returns></returns>
        public static char ToChar(CrudAction action)
        {
            switch (action)
            {
                case CrudAction.Insert: return 'I';
                case CrudAction.Update: return 'U';
                case CrudAction.Delete: return 'D';
                default: return '0';

            }

        }



    }
}
