﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaWorker.Abstract;
using BMS.VistaWorker.Data;
using BMS.VistaWorker.Reader.Abstract;

namespace BMS.VistaWorker.Reader.Concrete.Entities
{
    /// <summary>
    /// The ward location log.
    /// </summary>
    public class WardLocationLog : BaseEisEvsLogData<WardLocation>
    {


        /// <summary>
        /// Gets the crud action.
        /// </summary>
        public override CrudAction CrudAction { get; set; }



        /// <summary>
        /// Gets the id.
        /// </summary>
        public override int Id { get; set; }
        /// <summary>
        /// Gets or sets the action.
        /// </summary>
        /// <value>
        /// The action.
        /// </value>
        public char Action { get { return TranslateCrudAction.ToChar(CrudAction); } set { CrudAction = TranslateCrudAction.ToEnum(value); } }
        /// <summary>
        /// Gets the create date time.
        /// </summary>
        public override DateTime CreateDateTime { get; set; }

        /// <summary>
        /// Gets or sets the IEN.
        /// </summary>
        /// <value>
        /// The IEN.
        /// </value>
        public int IEN { get { return Convert.ToInt32(entity.IEN); } set { entity.IEN = value + ""; } }
        /// <summary>
        /// Gets or sets the name.
        /// </summary>
        /// <value>
        /// The name.
        /// </value>
        public String Name { get { return entity.Name; } set { entity.Name = value; } }
        /// <summary>
        /// Gets or sets the name of the specialty.
        /// </summary>
        /// <value>
        /// The name of the specialty.
        /// </value>
        public String SpecialtyName { get { return entity.SpecialtyName; } set { entity.SpecialtyName = value; } }
        /// <summary>
        /// Gets or sets the hospital location id (IEN).
        /// </summary>
        /// <value>
        /// The hospital location id.
        /// </value>
        public string HospitalLocationId { get { return entity.HospitalLocationId; } set { entity.HospitalLocationId = value; } }
        /// <summary>
        /// Gets or sets a value indicating whether this instance is currently out of service.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if this instance is currently out of service; otherwise, <c>false</c>.
        /// </value>
        public bool IsCurrentlyOutOfService { get { return entity.IsCurrentlyOutOfService; } set { entity.IsCurrentlyOutOfService = value; } }
        /// <summary>
        /// Gets or sets the specialty id.
        /// </summary>
        /// <value>
        /// The specialty id.
        /// </value>
        public int? SpecialtyId { get { return entity.SpecialtyId; } set { entity.SpecialtyId = value; } }



    }
}
