﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaIntegration.Mdws2.Abstract;
using BMS.VistaIntegration.Data;
using BMS.VistaIntegration.Mdws2.Maps.EIS;
using BMS.VistaIntegration.Data.WF;


namespace BMS.VistaIntegration.Mdws2.Maps.WF
{
    public class BedSwitchMap : FileMap<BedSwitch>
    {
        private static readonly BedSwitchMap instance = new BedSwitchMap();
        public static BedSwitchMap Instance { get { return instance; } }

        private BedSwitchMap()
        {
        }

        public override string FileNumber
        {
            get { return "405"; }
        }

        protected override void Map()
        {
                MapIen((m, s) => m.Ien = s);
                Map((m, s) => m.RoomBedIen = s, ".07");
                Map((m, s) => m.WardIen = s, ".06");
        }
    }
}
