﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaIntegration.Mdws2.Abstract;
using BMS.VistaIntegration.Data;

namespace BMS.VistaIntegration.Mdws2.Maps.EIS
{
    public class WardLocationMap : FileMap<WardLocation>
    {
        private static readonly WardLocationMap instance = new WardLocationMap();
        public static WardLocationMap Instance { get { return instance; } }

        private WardLocationMap()
        {
        }

        public override string FileNumber
        {
            get { return "42"; }
        }

        protected override void Map()
        {

                MapIen((m, s) => m.IEN = s);
                Map((m, s) => m.Name = s, ".01");
                Map((m, s) => m.SpecialtyId = s, ".017");
                Map((m, s) => m.IsCurrentlyOutOfService = s.VistAToBool(), ".2");
                Map((m, s) => m.HospitalLocationId = s, "44");

        }
    }
}
