﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaIntegration.Mdws2.Abstract;
using BMS.VistaIntegration.Data;

namespace BMS.VistaIntegration.Mdws2.Maps.EIS
{
    public class HospitalLocationMap : FileMap<HospitalLocation>
    {
        private static readonly HospitalLocationMap instance = new HospitalLocationMap();
        public static HospitalLocationMap Instance { get { return instance; } }

        private HospitalLocationMap() { }

        public override string FileNumber
        {
            get { return "44"; }
        }

        protected override void Map()
        {

                MapIen((e, value) => e.IEN = value);
                Map((e, value) => e.Name = value, ".01");
                Map((e, value) => e.Abbreviation = value, "1");
                Map((e, value) => e.Telephone = value, "99");

        }
    }
}
