﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaIntegration.Data;
using BMS.VistaIntegration.Mdws2.Maps.WF;
using BMS.VistaIntegration.Mdws2.Abstract;

namespace BMS.VistaIntegration.Mdws2.Implementation.WF
{
    public class ScheduledAdmissionCommand : BasePeriodCommand<ScheduledAdmission>
    {

        public ScheduledAdmissionCommand()
            : base(ScheduledAdmissionMap.Instance)
        {
        }

        public string PatientIen { get; set; }

        protected override string FieldLocation
        {
            get { return "0;2"; }
        }

        private const string PatientScreen = "I $P(^DGS(41.1,Y,0),U,1)={0} ";

        protected override string GetScreenParam()
        {
            string screen = base.GetScreenParam();
            if (!string.IsNullOrEmpty(PatientIen))
            {
                screen = string.Format(PatientScreen, PatientIen) + screen;
            }
            return screen;
        }

    }
}
