﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaIntegration.Mdws2.QuerySvcService;

namespace BMS.VistaIntegration.Mdws2.Abstract
{
    class TypeReferenceFetch<T> : IReferenceFetch<T>
    {
        private SortedList<string, IReferenceFetch<T>> dictionary = new SortedList<string, IReferenceFetch<T>>();

        public void Add(String type, IReferenceFetch<T> fetch)
        {

            if (dictionary.ContainsKey(type))
                throw new InvalidOperationException();
            dictionary[type] = fetch;
        }

        public void SetFields(QuerySvcSoap client, T entity, string ien)
        {

            string type = ien.VistAVariablePointerType();
            string value = ien.VistAVariablePointerValue();
            IReferenceFetch<T> referenceFetch = null;
            if (dictionary.TryGetValue(type, out referenceFetch))
                referenceFetch.SetFields(client, entity, value);

        }
    }
}
