﻿using System;

namespace BMS.VistaIntegration.Data
{
    [Serializable]
    public class PatientVisit
    {
        /// <summary>
        /// Gets or sets the patient gender.
        /// </summary>
        /// <value>
        /// The patient gender.
        /// </value>
        public string PatientGender { get; set; }
        /// <summary>
        /// Gets or sets the family name of the patient.
        /// </summary>
        /// <value>
        /// The family name of the patient.
        /// </value>
        public string PatientFamilyName { get; set; }
        /// <summary>
        /// Gets or sets the given name of the patient.
        /// </summary>
        /// <value>
        /// The given name of the patient.
        /// </value>
        public string PatientGivenName { get; set; }
        /// <summary>
        /// Gets or sets the patient's middle initial.
        /// </summary>
        /// <value>
        /// The patient's middle initial.
        /// </value>
        public string PatientMiddleInitial { get; set; }
        /// <summary>
        /// Gets or sets the patient's SSN.
        /// </summary>
        /// <value>
        /// The patient's SSN.
        /// </value>
        public string PatientSSN { get; set; }
        /// <summary>
        /// Gets or sets the patient's IEN.
        /// </summary>
        /// <value>
        /// The patient's IEN.
        /// </value>
        public string PatientIEN { get; set; }
        /// <summary>
        /// Gets or sets the patient's date of birth.
        /// </summary>
        /// <value>
        /// The patient's date of birth.
        /// </value>
        public DateTime? PatientDateOfBirth { get; set; }
        /// <summary>
        /// Gets or sets the admission date time.
        /// </summary>
        /// <value>
        /// The admission date time.
        /// </value>
        public DateTime? AdmissionDateTime { get; set; }
        /// <summary>
        /// Gets or sets the discharge date time.
        /// </summary>
        /// <value>
        /// The discharge date time.
        /// </value>
        public DateTime? DischargeDateTime { get; set; }
        /// <summary>
        /// Gets or sets the sending facility identifier.
        /// </summary>
        /// <value>
        /// The sending facility identifier.
        /// </value>
        public string SendingFacilityIdentifier { get; set; }
        /// <summary>
        /// Gets or sets the date time the ADT event was recorded.
        /// </summary>
        /// <value>
        /// The date time the ADT event was recorded.
        /// </value>
        public DateTime? RecordedDateTime { get; set; }
        /// <summary>
        /// Gets or sets the assigned ward.
        /// </summary>
        /// <value>
        /// The assigned ward.
        /// </value>
        public string AssignedWard { get; set; }
        /// <summary>
        /// Gets or sets the assigned room.
        /// </summary>
        /// <value>
        /// The assigned room.
        /// </value>
        public string AssignedRoom { get; set; }
        /// <summary>
        /// Gets or sets the assigned bed.
        /// </summary>
        /// <value>
        /// The assigned bed.
        /// </value>
        public string AssignedBed { get; set; }
        /// <summary>
        /// Gets or sets the attending doctor identifier.
        /// </summary>
        /// <value>
        /// The attending doctor identifier.
        /// </value>
        public string AttendingDoctorIdentifier { get; set; }
        /// <summary>
        /// Gets or sets the family name of the attending doctor.
        /// </summary>
        /// <value>
        /// The family name of the attending doctor.
        /// </value>
        public string AttendingDoctorFamilyName { get; set; }
        /// <summary>
        /// Gets or sets the given name of the attending doctor.
        /// </summary>
        /// <value>
        /// The given name of the attending doctor.
        /// </value>
        public string AttendingDoctorGivenName { get; set; }
        /// <summary>
        /// Gets or sets the visit number.
        /// </summary>
        /// <value>
        /// The visit number.
        /// </value>
        public string VisitId { get; set; }
        /// <summary>
        /// Gets or sets the type of the event.
        /// </summary>
        /// <value>
        /// The type of the event.
        /// </value>
        public string EventType { get; set; }
    }
}
