﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.Serialization;

namespace BMS.VistaIntegration.Data
{
    /// <summary>
    /// VistA display group contract.
    /// </summary>
    [Serializable] 
    public class DisplayGroup : IConcept
    {
        /// <summary>
        /// Gets or sets the IEN.
        /// </summary>
        /// <value>
        /// The IEN.
        /// </value>
        
        public string IEN { get; set; }

        /// <summary>
        /// Gets or sets the name.
        /// </summary>
        /// <value>
        /// The name.
        /// </value>
        
        public string Name { get; set; }

        /// <summary>
        /// Gets or sets the name of the mixed.
        /// </summary>
        /// <value>
        /// The name of the mixed.
        /// </value>
        
        public string MixedName { get; set; }

        /// <summary>
        /// Gets or sets the short name.
        /// </summary>
        /// <value>
        /// The short name.
        /// </value>
        
        public string ShortName { get; set; }

        public override string ToString()
        {
            return "DisplayGroup:" + Name;
        }
    }
}
