﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using InterSystems.Data.CacheClient;
using BMS.VistaIntegration.Data;
using BMS.VistaIntegration.Data.WF;

namespace BMS.VistaIntegration.Cache.Commands
{
    public class Translators
    {
        public static string Translate<T>(CacheDataReader reader, bool isBedHoldSupported, out IList<T> result) where T : class
        {
            string lastIen = "0";            
            if (typeof(T) == typeof(HospitalLocation))
            {
                result = Translate_HospitalLocation(reader, out lastIen) as IList<T>;
                return lastIen;
            }
            if (typeof(T) == typeof(WardLocation))
            {
                result = Translate_WardLocation(reader, out lastIen) as IList<T>;
                return lastIen;
            }
            if (typeof(T) == typeof(RoomBed))
            {
                result = Translate_RoomBed(reader, isBedHoldSupported, out lastIen) as IList<T>;
                return lastIen;
            }
            if (typeof(T) == typeof(NewPerson))
            {
                result = Translate_NewPerson(reader, out lastIen) as IList<T>;
                return lastIen;
            }
            if (typeof(T) == typeof(Patient))
            {
                result = Translate_Patient(reader, out lastIen) as IList<T>;
                return lastIen;
            }
            if (typeof(T) == typeof(FacilityTreatingSpecialty))
            {
                result = Translate_FacilityTreatingSpecialty(reader, out lastIen) as IList<T>;
                return lastIen;
            }
            if (typeof(T) == typeof(FacilityMovementType))
            {
                result = Translate_FacilityMovementType(reader, out lastIen) as IList<T>;
                return lastIen;
            }
            if (typeof(T) == typeof(OrderableItem))
            {
                result = Translate_OrderableItem(reader, out lastIen) as IList<T>;
                return lastIen;
            }
            if (typeof(T) == typeof(Specialty))
            {
                result = Translate_Specialty(reader, out lastIen) as IList<T>;
                return lastIen;
            }
            if (typeof(T) == typeof(OrderStatus))
            {
                result = Translate_OrderStatus(reader, out lastIen) as IList<T>;
                return lastIen;
            }
            if (typeof(T) == typeof(MedicalCenterDivision))
            {
                result = Translate_MedicalCenterDivision(reader, out lastIen) as IList<T>;
                return lastIen;
            }
            if (typeof(T) == typeof(OrderAction))
            {
                result = Translate_OrderAction(reader, out lastIen) as IList<T>;
                return lastIen;
            }
            if (typeof(T) == typeof(PatientAppointment))
            {
                result = Translate_PatientAppointment(reader, out lastIen) as IList<T>;
                return lastIen;
            }
            if (typeof(T) == typeof(PatientMovement))
            {
                result = Translate_PatientMovement(reader, isBedHoldSupported, out lastIen) as IList<T>;
                return lastIen;
            }
            if (typeof(T) == typeof(ScheduledAdmission))
            {
                result = Translate_ScheduledAdmission(reader, out lastIen) as IList<T>;
                return lastIen;
            }
            if (typeof(T) == typeof(BedSwitch))
            {
                result = Translate_BedSwitch(reader, out lastIen) as IList<T>;
                return lastIen;
            }
            if (typeof(T) == typeof(string))
            {
                result = Translate_CancelledOrder(reader, out lastIen) as IList<T>;
                return lastIen;
            }
            if (typeof(T) == typeof(AdmittedPatient))
            {
                result = Translate_AdmittedPatient(reader, out lastIen) as IList<T>;
                return lastIen;
            }

            if (typeof(T) == typeof(PatientMovementIen))
            {
                result = Translate_PatientMovementIen(reader, out lastIen) as IList<T>;
                return lastIen;
            }
            result = null;
            return null;
        }

        #region EIS Data

        public static IList<HospitalLocation> Translate_HospitalLocation(CacheDataReader reader, out string lastIen)
        {
            IList<HospitalLocation> result = new List<HospitalLocation>();
            HospitalLocation obj = null;
            lastIen = null;
            while (reader.Read())
            {
                obj = new HospitalLocation();
                obj.IEN = GetReaderValue(reader["IEN"].ToString());
                obj.Name = GetReaderValue(reader["NAME"].ToString());
                obj.Abbreviation = GetReaderValue(reader["ABBREVIATION"].ToString());
                obj.Telephone = GetReaderValue(reader["TELEPHONE"].ToString());
                obj.WardLocationId = GetReaderValue(reader["WARD_IEN"].ToString());                
                obj.WardLocation = TranslateWard(reader);
                lastIen = obj.IEN;
                result.Add(obj);
            }
            return result;
        }

        public static IList<WardLocation> Translate_WardLocation(CacheDataReader reader, out string lastIen)
        {
            IList<WardLocation> result = new List<WardLocation>();
            WardLocation obj = null;
            lastIen = null;
            while (reader.Read())
            {
                obj = TranslateWard(reader);
                if (obj == null) continue;
                lastIen = obj.IEN;
                result.Add(obj);
            }
            return result;
        }

        public static IList<RoomBed> Translate_RoomBed(CacheDataReader reader, bool isBedHoldSupported, out string lastIen)
        {
            IList<RoomBed> result = new List<RoomBed>();
            RoomBed bed = null;
            RoomBed obj = null;
            DateTime? outOfServiceDate = null;
            WardLocation ward = null;
            lastIen = null;
            while (reader.Read())
            {
                if (!string.IsNullOrEmpty(reader["OUT_OF_SERVICE_DATE"].ToString()))
                    outOfServiceDate = DateTime.Parse(GetReaderValue(reader["OUT_OF_SERVICE_DATE"].ToString()));
                else
                    outOfServiceDate = null;
                bed = result.Where(a => a.IEN == GetReaderValue(reader["IEN"].ToString())).FirstOrDefault();
                if (bed != null)
                {
                    if (bed.WardsWhichCanAssign == null) bed.WardsWhichCanAssign = new List<string>();
                    if (bed.Wards == null) bed.Wards = new List<WardLocation>();
                    if (bed.OutOfServiceDates == null) bed.OutOfServiceDates = new List<DateTime>();
                    if (!bed.WardsWhichCanAssign.Contains(GetReaderValue(reader["WARD_IEN"].ToString())))
                    {
                        ward = TranslateWard(reader);
                        if (ward != null)
                        {
                            bed.WardsWhichCanAssign.Add(ward.IEN);
                            bed.Wards.Add(ward);
                        }
                    }
                    if (outOfServiceDate.HasValue && !bed.OutOfServiceDates.Contains(outOfServiceDate.Value))
                        bed.OutOfServiceDates.Add(outOfServiceDate.Value);
                    lastIen = bed.IEN;
                }
                else
                {
                    obj = new RoomBed();
                    obj.IEN = GetReaderValue(reader["IEN"].ToString());
                    obj.Name = GetReaderValue(reader["NAME"].ToString());
                    obj.CurrentlyOutOfService = (GetReaderValue(reader["CURRENTLY_OUTOFSERVICE"].ToString()) == "1") ? true : false;
                    if (obj.WardsWhichCanAssign == null) obj.WardsWhichCanAssign = new List<string>();
                    if (obj.Wards == null) obj.Wards = new List<WardLocation>();
                    if (obj.OutOfServiceDates == null) obj.OutOfServiceDates = new List<DateTime>();
                    if (outOfServiceDate.HasValue)
                        obj.OutOfServiceDates.Add(outOfServiceDate.Value);
                    ward = TranslateWard(reader);
                    if (ward != null)
                    {
                        obj.WardsWhichCanAssign.Add(ward.IEN);
                        obj.Wards.Add(ward);
                    }                    
                    if (isBedHoldSupported)
                    {
                        obj.BedHoldPatientIen = GetReaderValue(reader["BED_HOLD"].ToString());
                        obj.BedHoldStartDate = (string.IsNullOrEmpty(reader["BED_HOLD_DATE"].ToString())) ? (DateTime?)null : DateTime.Parse(GetReaderValue(reader["BED_HOLD_DATE"].ToString()));
                    }
                    result.Add(obj);
                    lastIen = obj.IEN;
                }
            }
            return result;
        }

        public static IList<Patient> Translate_Patient(CacheDataReader reader, out string lastIen)
        {
            IList<Patient> result = new List<Patient>();
            Patient obj = null;
            lastIen = null;
            while (reader.Read())
            {
                obj = TranslatePatient(reader);
                if (obj != null)
                {
                    lastIen = obj.IEN;
                    result.Add(obj);
                }
            }
            return result;
        }

        public static IList<NewPerson> Translate_NewPerson(CacheDataReader reader, out string lastIen)
        {
            IList<NewPerson> result = new List<NewPerson>();
            NewPerson obj = null;
            lastIen = null;
            while (reader.Read())
            {
                obj = new NewPerson();
                obj.IEN = GetReaderValue(reader["IEN"].ToString());
                obj.Name = GetReaderValue(reader["NAME"].ToString());
                lastIen = obj.IEN;
                result.Add(obj);
            }
            return result;
        }

        #endregion

        #region EVS Data

        public static IList<FacilityTreatingSpecialty> Translate_FacilityTreatingSpecialty(CacheDataReader reader, out string lastIen)
        {
            IList<FacilityTreatingSpecialty> result = new List<FacilityTreatingSpecialty>();
            FacilityTreatingSpecialty obj = null;
            lastIen = null;
            while (reader.Read())
            {
                obj = new FacilityTreatingSpecialty();
                obj.IEN = GetReaderValue(reader["IEN"].ToString());
                obj.Name = GetReaderValue(reader["NAME"].ToString());
                obj.SpecialtyId = GetReaderValue(reader["SPECIALTY"].ToString());
                lastIen = obj.IEN;
                result.Add(obj);
            }
            return result;
        }

        public static IList<FacilityMovementType> Translate_FacilityMovementType(CacheDataReader reader, out string lastIen)
        {
            IList<FacilityMovementType> result = new List<FacilityMovementType>();
            FacilityMovementType obj = null;
            lastIen = null;
            while (reader.Read())
            {
                obj = new FacilityMovementType();
                obj.IEN = GetReaderValue(reader["IEN"].ToString());
                obj.Name = GetReaderValue(reader["NAME"].ToString());
                obj.Active = (GetReaderValue(reader["ACTIVE"].ToString()).Equals("1")) ? true : false;
                lastIen = obj.IEN;
                result.Add(obj);
            }
            return result;
        }

        public static IList<OrderableItem> Translate_OrderableItem(CacheDataReader reader, out string lastIen)
        {
            IList<OrderableItem> result = new List<OrderableItem>();
            OrderableItem obj = null;
            lastIen = null;
            while (reader.Read())
            {
                obj = new OrderableItem();
                obj.IEN = GetReaderValue(reader["IEN"].ToString());
                obj.Name = GetReaderValue(reader["NAME"].ToString());
                obj.DisplayGroupId = GetReaderValue(reader["DISPLAY_GROUP"].ToString());
                obj.Inactivated = GetReaderValue(reader["INACTIVATED"].ToString());
                obj.PackageName = GetReaderValue(reader["PACKAGE_NAME"].ToString());
                lastIen = obj.IEN;
                result.Add(obj);
            }
            return result;
        }

        public static IList<Specialty> Translate_Specialty(CacheDataReader reader, out string lastIen)
        {
            IList<Specialty> result = new List<Specialty>();
            Specialty obj = null;
            lastIen = null;
            while (reader.Read())
            {
                obj = new Specialty();
                obj.IEN = GetReaderValue(reader["IEN"].ToString());
                obj.Name = GetReaderValue(reader["NAME"].ToString());
                lastIen = obj.IEN;
                result.Add(obj);
            }
            return result;
        }

        public static IList<OrderStatus> Translate_OrderStatus(CacheDataReader reader, out string lastIen)
        {
            IList<OrderStatus> result = new List<OrderStatus>();
            OrderStatus obj = null;
            lastIen = null;
            while (reader.Read())
            {
                obj = new OrderStatus();
                obj.IEN = GetReaderValue(reader["IEN"].ToString());
                obj.Name = GetReaderValue(reader["NAME"].ToString());
                lastIen = obj.IEN;
                result.Add(obj);
            }
            return result;
        }

        public static IList<MedicalCenterDivision> Translate_MedicalCenterDivision(CacheDataReader reader, out string lastIen)
        {
            IList<MedicalCenterDivision> result = new List<MedicalCenterDivision>();
            MedicalCenterDivision obj = null;
            lastIen = null;
            while (reader.Read())
            {
                obj = new MedicalCenterDivision();
                obj.IEN = GetReaderValue(reader["IEN"].ToString());
                obj.Name = GetReaderValue(reader["NAME"].ToString());
                obj.FacilityNumber = GetReaderValue(reader["FACILITY_NUMBER"].ToString());
                lastIen = obj.IEN;
                result.Add(obj);
            }
            return result;
        }

        #endregion

        #region WF Data

        public static IList<OrderAction> Translate_OrderAction(CacheDataReader reader, out string lastIen)
        {
            IList<OrderAction> result = new List<OrderAction>();
            OrderAction obj = null;
            lastIen = null;
            while (reader.Read())
            {
                OrderAction order = result.Where(a => a.OrderId == GetReaderValue(reader["IEN"].ToString())).FirstOrDefault();
                if (order != null)
                {
                    if (order.Order.OrderOrderableItemIds == null) order.Order.OrderOrderableItemIds = new List<string>();
                    if (!order.Order.OrderOrderableItemIds.Contains(GetReaderValue(reader["ORDERABLE_ITEM"].ToString())))
                        order.Order.OrderOrderableItemIds.Add(GetReaderValue(reader["ORDERABLE_ITEM"].ToString()));
                    lastIen = order.OrderId;
                }
                else
                {
                    obj = new OrderAction();
                    obj.Order = new Order();
                    if (string.IsNullOrEmpty(GetReaderValue(reader["DC_DATE"].ToString())))
                        obj.Order.DC_Date = null;
                    else
                        obj.Order.DC_Date = DateTime.Parse(GetReaderValue(reader["DC_DATE"].ToString()));
                    obj.Order.DisplayGroupId = GetReaderValue(reader["DISPLAY_GROUP"].ToString());
                    obj.Order.HospitalLocationId = GetReaderValue(reader["HOSPITAL_LOCATION_IEN"].ToString());
                    obj.Order.HospitalLocation = TranslateHospital(reader);
                    obj.Order.IEN = GetReaderValue(reader["IEN"].ToString());
                    if (string.IsNullOrEmpty(GetReaderValue(reader["DATE_OF_LAST_ACTIVITY"].ToString())))
                        obj.Order.LastActivityDate = null;
                    else
                        obj.Order.LastActivityDate = DateTime.Parse(GetReaderValue(reader["DATE_OF_LAST_ACTIVITY"].ToString()));
                    obj.Order.OrderNumber = GetReaderValue(reader["ORDER_"].ToString());
                    if (obj.Order.OrderOrderableItemIds == null) obj.Order.OrderOrderableItemIds = new List<string>();
                    obj.Order.OrderOrderableItemIds.Add(GetReaderValue(reader["ORDERABLE_ITEM"].ToString()));
                    obj.Order.PatientId = GetReaderValue(reader["PATIENT"].ToString());
                    obj.Order.Patient = TranslatePatient(reader);
                    if (string.IsNullOrEmpty(GetReaderValue(reader["START_DATE"].ToString())))
                        obj.Order.StartDate = null;
                    else
                        obj.Order.StartDate = DateTime.Parse(GetReaderValue(reader["START_DATE"].ToString()));
                    if (string.IsNullOrEmpty(GetReaderValue(reader["STOP_DATE"].ToString())))
                        obj.Order.StopDate = null;
                    else
                        obj.Order.StopDate = DateTime.Parse(GetReaderValue(reader["STOP_DATE"].ToString()));
                    obj.Order.StatusId = GetReaderValue(reader["STATUS"].ToString());
                    obj.Order.OrderStatus = new OrderStatus() { IEN = GetReaderValue(reader["STATUS"].ToString()), Name = GetReaderValue(reader["STATUS_NAME"].ToString()) };
                    if (string.IsNullOrEmpty(obj.Order.OrderStatus.IEN))
                        obj.Order.OrderStatus = null;
                    if (string.IsNullOrEmpty(GetReaderValue(reader["DATE_CLERK_VERIFIED"].ToString())))
                        obj.DateTimeClerkVerified = null;
                    else
                        obj.DateTimeClerkVerified = DateTime.Parse(GetReaderValue(reader["DATE_CLERK_VERIFIED"].ToString()));
                    if (string.IsNullOrEmpty(GetReaderValue(reader["DATE_NURSE_VERIFIED"].ToString())))
                        obj.DateTimeNurseVerified = null;
                    else
                        obj.DateTimeNurseVerified = DateTime.Parse(GetReaderValue(reader["DATE_NURSE_VERIFIED"].ToString()));
                    if (!string.IsNullOrEmpty(GetReaderValue(reader["DATE_ORDERED"].ToString())))
                        obj.DateTimeOrdered = DateTime.Parse(GetReaderValue(reader["DATE_ORDERED"].ToString()));
                    if (string.IsNullOrEmpty(GetReaderValue(reader["DATE_SIGNED"].ToString())))
                        obj.DateTimeSigned = null;
                    else
                        obj.DateTimeSigned = DateTime.Parse(GetReaderValue(reader["DATE_SIGNED"].ToString()));
                    obj.OrderId = obj.Order.IEN;
                    obj.OrderText = GetReaderValue(reader["ORDER_TEXT"].ToString());
                    obj.ProviderId = GetReaderValue(reader["PROVIDER"].ToString());
                    obj.Provider = new NewPerson() { IEN = GetReaderValue(reader["PROVIDER"].ToString()), Name = GetReaderValue(reader["PROVIDER_NAME"].ToString()) };
                    if (string.IsNullOrEmpty(obj.Provider.IEN))
                        obj.Provider = null;
                    if (string.IsNullOrEmpty(GetReaderValue(reader["RELEASE_DATE"].ToString())))
                        obj.ReleaseDateTime = null;
                    else
                        obj.ReleaseDateTime = DateTime.Parse(GetReaderValue(reader["RELEASE_DATE"].ToString()));
                    obj.ReleaseStatus = GetReaderValue(reader["RELEASE_STATUS"].ToString());
                    obj.SignatureStatus = GetReaderValue(reader["SIGNATURE_STATUS"].ToString());
                    obj.SignedById = GetReaderValue(reader["SIGNED_BY"].ToString());
                    obj.SignedBy = new NewPerson() { IEN = GetReaderValue(reader["SIGNED_BY"].ToString()), Name = GetReaderValue(reader["SIGNED_BY_NAME"].ToString()) };
                    if (string.IsNullOrEmpty(obj.SignedBy.IEN))
                        obj.SignedBy = null;
                    obj.VerifyingClerkId = GetReaderValue(reader["VERIFYING_CLERK"].ToString());
                    obj.VerifyingClerk = new NewPerson() { IEN = GetReaderValue(reader["VERIFYING_CLERK"].ToString()), Name = GetReaderValue(reader["VERIFYING_CLERK_NAME"].ToString()) };
                    if (string.IsNullOrEmpty(obj.VerifyingClerk.IEN))
                        obj.VerifyingClerk = null;
                    obj.VerifyingNurseId = GetReaderValue(reader["VERIFYING_NURSE"].ToString());
                    obj.VerifyingNurse = new NewPerson() { IEN = GetReaderValue(reader["VERIFYING_NURSE"].ToString()), Name = GetReaderValue(reader["VERIFYING_NURSE_NAME"].ToString()) };
                    if (string.IsNullOrEmpty(obj.VerifyingNurse.IEN))
                        obj.VerifyingNurse = null;
                    lastIen = obj.Order.IEN;
                    result.Add(obj);
                }
            }
            return result;
        }

        public static IList<PatientAppointment> Translate_PatientAppointment(CacheDataReader reader, out string lastIen)
        {
            IList<PatientAppointment> result = new List<PatientAppointment>();
            PatientAppointment obj = null;
            lastIen = null;
            while (reader.Read())
            {
                obj = new PatientAppointment();
                if (!string.IsNullOrEmpty(GetReaderValue(reader["APPOINTMENT_DATETIME"].ToString())))
                    obj.AppointmentDateTime = DateTime.Parse(GetReaderValue(reader["APPOINTMENT_DATETIME"].ToString()));
                obj.CurrentStatus = GetReaderValue(reader["CURRENT_STATUS"].ToString());
                if (string.IsNullOrEmpty(GetReaderValue(reader["DATE_APPOINTMENT_MADE"].ToString())))
                    obj.DateAppointmentMade = null;
                else
                    obj.DateAppointmentMade = DateTime.Parse(GetReaderValue(reader["DATE_APPOINTMENT_MADE"].ToString()));
                obj.HospitalLocationId = GetReaderValue(reader["HOSPITAL_LOCATION_IEN"].ToString());
                obj.HospitalLocation = TranslateHospital(reader);
                obj.PatientId = GetReaderValue(reader["PATIENT"].ToString());
                obj.Patient = TranslatePatient(reader);
                obj.Status = GetReaderValue(reader["STATUS"].ToString());
                obj.TelephoneOfClinic = GetReaderValue(reader["TELEPHONE_OF_CLINIC"].ToString());
                lastIen = obj.AppointmentDateTime.ToString();
                result.Add(obj);
            }
            return result;
        }

        public static IList<PatientMovement> Translate_PatientMovement(CacheDataReader reader, bool isBedHoldSupported, out string lastIen)
        {
            IList<PatientMovement> result = new List<PatientMovement>();
            PatientMovement obj = null;
            PatientMovement pm = null;
            DateTime? outOfServiceDate = null;
            WardLocation ward = null;
            lastIen = null;
            while (reader.Read())
            {
                if (!string.IsNullOrEmpty(GetReaderValue(reader["RB_OUT_OF_SERVICE_DATE"].ToString())))
                    outOfServiceDate = DateTime.Parse(GetReaderValue(reader["RB_OUT_OF_SERVICE_DATE"].ToString()));
                else
                    outOfServiceDate = null;
                pm = result.Where(a => a.IEN == GetReaderValue(reader["IEN"].ToString())).FirstOrDefault();
                if (pm != null && pm.Bed != null)
                {
                    if (pm.Bed.OutOfServiceDates == null) pm.Bed.OutOfServiceDates = new List<DateTime>();
                    if (pm.Bed.Wards == null) pm.Bed.Wards = new List<WardLocation>();
                    if (pm.Bed.WardsWhichCanAssign == null) pm.Bed.WardsWhichCanAssign = new List<string>();                    
                    if (!pm.Bed.WardsWhichCanAssign.Contains(GetReaderValue(reader["RB_WARD_IEN"].ToString())))
                    {
                        ward = TranslateWard2(reader);
                        if (ward != null)
                        {
                            pm.Bed.WardsWhichCanAssign.Add(ward.IEN);
                            pm.Bed.Wards.Add(ward);
                        }
                    }
                    if (outOfServiceDate.HasValue && !pm.Bed.OutOfServiceDates.Contains(outOfServiceDate.Value))
                        pm.Bed.OutOfServiceDates.Add(outOfServiceDate.Value);
                    lastIen = pm.IEN;
                }
                else
                {
                    obj = new PatientMovement();
                    if (!string.IsNullOrEmpty(GetReaderValue(reader["DATE_TIME"].ToString())))
                        obj.DateTime = DateTime.Parse(GetReaderValue(reader["DATE_TIME"].ToString()));
                    obj.EnteredById = GetReaderValue(reader["ENTERED_BY"].ToString());
                    obj.EnteredBy = new NewPerson() { IEN = GetReaderValue(reader["ENTERED_BY"].ToString()), Name = GetReaderValue(reader["ENTERED_BY_NAME"].ToString()) };
                    if (string.IsNullOrEmpty(obj.EnteredBy.IEN))
                        obj.EnteredBy = null;
                    if (!string.IsNullOrEmpty(GetReaderValue(reader["ENTERED_ON_DATETIME"].ToString())))
                        obj.EnteredOnDateTime = DateTime.Parse(GetReaderValue(reader["ENTERED_ON_DATETIME"].ToString()));
                    obj.IEN = GetReaderValue(reader["IEN"].ToString());
                    obj.PatientId = GetReaderValue(reader["PATIENT"].ToString());
                    obj.Patient = TranslatePatient(reader);
                    obj.RoomBedId = GetReaderValue(reader["RB_IEN"].ToString());
                    obj.TransactionTypeId = GetReaderValue(reader["TRANSACTION_ID"].ToString());
                    obj.TypeOfMovementId = GetReaderValue(reader["TYPE_OF_MOVEMENT"].ToString());
                    obj.TypeOfMovement = new FacilityMovementType();
                    obj.TypeOfMovement.IEN = GetReaderValue(reader["TYPE_OF_MOVEMENT"].ToString());
                    obj.TypeOfMovement.Name = GetReaderValue(reader["TYPE_OF_MOVEMENT_NAME"].ToString());
                    if (string.IsNullOrEmpty(obj.TypeOfMovement.IEN))
                        obj.TypeOfMovement = null;
                    obj.WardLocationId = GetReaderValue(reader["WARD_IEN"].ToString());
                    obj.Ward = TranslateWard(reader);
                    obj.Bed = new RoomBed();
                    obj.Bed.IEN = GetReaderValue(reader["RB_IEN"].ToString());
                    obj.Bed.Name = GetReaderValue(reader["RB_NAME"].ToString());
                    if (isBedHoldSupported)
                    {
                        obj.Bed.BedHoldPatientIen = GetReaderValue(reader["BED_HOLD"].ToString());
                        obj.Bed.BedHoldStartDate = (string.IsNullOrEmpty(GetReaderValue(reader["BED_HOLD_DATE"].ToString()))) ? (DateTime?)null : DateTime.Parse(GetReaderValue(reader["BED_HOLD_DATE"].ToString()));
                    }
                    obj.Bed.CurrentlyOutOfService = (GetReaderValue(reader["RB_OUT_OF_SERVICE"].ToString()) == "1") ? true : false;
                    if (obj.Bed.OutOfServiceDates == null) obj.Bed.OutOfServiceDates = new List<DateTime>();
                    if (obj.Bed.Wards == null) obj.Bed.Wards = new List<WardLocation>();
                    if (obj.Bed.WardsWhichCanAssign == null) obj.Bed.WardsWhichCanAssign = new List<string>();                    
                    if (outOfServiceDate.HasValue)
                        obj.Bed.OutOfServiceDates.Add(outOfServiceDate.Value);
                    ward = TranslateWard2(reader);
                    if (ward != null)
                    {
                        obj.Bed.WardsWhichCanAssign.Add(ward.IEN);
                        obj.Bed.Wards.Add(ward);
                    }
                    if (string.IsNullOrEmpty(obj.Bed.IEN))
                        obj.Bed = null;
                    obj.CurrentAdmissionIen = GetReaderValue(reader["CURRENT_ADMISSION"].ToString());
                    lastIen = obj.IEN;
                    result.Add(obj);
                }
            }
            return result;
        }

        public static IList<ScheduledAdmission> Translate_ScheduledAdmission(CacheDataReader reader, out string lastIen)
        {
            IList<ScheduledAdmission> result = new List<ScheduledAdmission>();
            ScheduledAdmission obj = null;
            lastIen = null;
            while (reader.Read())
            {
                obj = new ScheduledAdmission();
                obj.AdmittingDiagnosis = GetReaderValue(reader["ADMITTING_DIAGNOSIS"].ToString());
                obj.CancelledById = GetReaderValue(reader["CANCELLED_BY"].ToString());
                if (string.IsNullOrEmpty(GetReaderValue(reader["DATETIME_CANCELLED"].ToString())))
                    obj.DateTimeCancelled = null;
                else
                    obj.DateTimeCancelled = DateTime.Parse(GetReaderValue(reader["DATETIME_CANCELLED"].ToString()));
                obj.IEN = GetReaderValue(reader["IEN"].ToString());
                if (string.IsNullOrEmpty(GetReaderValue(reader["LENGTH_OF_STAY_EXPECTED"].ToString())))
                    obj.LengthOfStayExpected = null;
                else
                    obj.LengthOfStayExpected = int.Parse(GetReaderValue(reader["LENGTH_OF_STAY_EXPECTED"].ToString()));
                obj.MedicalCenterDivisionId = GetReaderValue(reader["DIVISION"].ToString());
                obj.MedicalCenterDivision = new MedicalCenterDivision();
                obj.MedicalCenterDivision.IEN = GetReaderValue(reader["DIVISION"].ToString());
                obj.MedicalCenterDivision.Name = GetReaderValue(reader["DIVISION_NAME"].ToString());
                if (string.IsNullOrEmpty(obj.MedicalCenterDivision.IEN))
                    obj.MedicalCenterDivision = null;
                obj.PatientId = GetReaderValue(reader["PATIENT"].ToString());
                obj.Patient = TranslatePatient(reader);
                obj.ProviderId = GetReaderValue(reader["PROVIDER"].ToString());
                obj.Provider = new NewPerson() { IEN = GetReaderValue(reader["PROVIDER"].ToString()), Name = GetReaderValue(reader["PROVIDER_NAME"].ToString()) };
                if (string.IsNullOrEmpty(obj.Provider.IEN))
                    obj.Provider = null;
                if (!string.IsNullOrEmpty(GetReaderValue(reader["RESERVATION_DATETIME"].ToString())))
                    obj.ReservationDateTime = DateTime.Parse(GetReaderValue(reader["RESERVATION_DATETIME"].ToString()));
                obj.SchedulerId = GetReaderValue(reader["SCHEDULER"].ToString());
                obj.Scheduler = new NewPerson() { IEN = GetReaderValue(reader["SCHEDULER"].ToString()), Name = GetReaderValue(reader["SCHEDULER_NAME"].ToString()) };
                if (string.IsNullOrEmpty(obj.Scheduler.IEN))
                    obj.Scheduler = null;
                obj.Surgery = GetReaderValue(reader["SURGERY"].ToString());
                obj.TreatingSpecialtyId = GetReaderValue(reader["TREATING_SPECIALTY"].ToString());
                obj.TreatingSpecialty = new FacilityTreatingSpecialty();
                obj.TreatingSpecialty.IEN = GetReaderValue(reader["TREATING_SPECIALTY"].ToString());
                obj.TreatingSpecialty.Name = GetReaderValue(reader["TREATING_SPECIALTY_NAME"].ToString());
                if (string.IsNullOrEmpty(obj.TreatingSpecialty.IEN))
                    obj.TreatingSpecialty = null;
                obj.WardLocationId = GetReaderValue(reader["WARD_IEN"].ToString());
                obj.Ward = TranslateWard(reader);
                lastIen = obj.IEN;
                result.Add(obj);
            }
            return result;
        }

        public static IList<BedSwitch> Translate_BedSwitch(CacheDataReader reader, out string lastIen)
        {
            IList<BedSwitch> result = new List<BedSwitch>();
            BedSwitch obj = null;
            lastIen = null;
            while (reader.Read())
            {
                obj = new BedSwitch();
                obj.Ien = GetReaderValue(reader["IEN"].ToString());
                obj.RoomBedIen = GetReaderValue(reader["ROOMBED"].ToString());
                obj.WardIen = GetReaderValue(reader["WARD_LOCATION"].ToString());                
                lastIen = obj.Ien;
                result.Add(obj);
            }
            return result;
        }

        public static IList<string> Translate_CancelledOrder(CacheDataReader reader, out string lastIen)
        {
            IList<string> result = new List<string>();
            string obj = null;
            lastIen = null;
            while (reader.Read())
            {                
                obj = GetReaderValue(reader["IEN"].ToString());                
                lastIen = obj;
                result.Add(obj);
            }
            return result;
        }

        public static IList<AdmittedPatient> Translate_AdmittedPatient(CacheDataReader reader, out string lastIen)
        {
            IList<AdmittedPatient> result = new List<AdmittedPatient>();
            AdmittedPatient obj = null;
            lastIen = null;
            while (reader.Read())
            {
                obj = new AdmittedPatient();
                obj.IEN = GetReaderValue(reader["IEN"].ToString());
                obj.Name = GetReaderValue(reader["NAME"].ToString());
                obj.SSN = GetSsn(GetReaderValue(reader["SOCIAL_SECURITY_NUMBER"].ToString()));
                obj.AdmissionIen = GetReaderValue(reader["CURRENT_ADMISSION"].ToString());
                obj.MovementIen = GetReaderValue(reader["CURRENT_MOVEMENT"].ToString());
                lastIen = obj.IEN;
                result.Add(obj);
            }
            return result;
        }

        public static IList<PatientMovementIen> Translate_PatientMovementIen(CacheDataReader reader, out string lastIen)
        {
            IList<PatientMovementIen> result = new List<PatientMovementIen>();
            PatientMovementIen obj = null;
            lastIen = null;
            while (reader.Read())
            {
                obj = new PatientMovementIen();
                obj.IEN = GetReaderValue(reader["IEN"].ToString());
                if (!string.IsNullOrEmpty(GetReaderValue(reader["DATE_TIME"].ToString())))
                    obj.MovementDate = DateTime.Parse(GetReaderValue(reader["DATE_TIME"].ToString()));
                lastIen = obj.IEN;
                result.Add(obj);
            }
            return result;
        }

        #endregion

        private static Patient TranslatePatient(CacheDataReader reader)
        {
            Patient obj = new Patient();
            obj.IEN = GetReaderValue(reader["PATIENT"].ToString());
            if (string.IsNullOrEmpty(obj.IEN))
                return null;
            obj.Name = GetReaderValue(reader["PATIENT_NAME"].ToString());
            DateTime dob = DateTime.Now;
            DateTime.TryParse(GetReaderValue(reader["PATIENT_DATE_OF_BIRTH"].ToString()), out dob);
            obj.DateOfBirth = dob;
            obj.Name1U4N = GetReaderValue(reader["f1U4N"].ToString());
            obj.Sex = null;
            if (!string.IsNullOrEmpty(GetReaderValue(reader["PATIENT_SEX"].ToString())))
                obj.Sex = char.Parse(GetReaderValue(reader["PATIENT_SEX"].ToString()).Substring(0, 1));
            obj.SocialSecurityNumber = GetSsn(GetReaderValue(reader["SOCIAL_SECURITY_NUMBER"].ToString()));
            obj.TreatingSpecialtyId = GetReaderValue(reader["PATIENT_TREATING_SPECIALTY"].ToString());
            obj.TreatingSpecialty = new FacilityTreatingSpecialty();
            obj.TreatingSpecialty.IEN = GetReaderValue(reader["PATIENT_TREATING_SPECIALTY"].ToString());
            obj.TreatingSpecialty.Name = GetReaderValue(reader["PATIENT_TREATING_SPECIALTY_NAME"].ToString());
            if (string.IsNullOrEmpty(obj.TreatingSpecialty.IEN))
                obj.TreatingSpecialty = null;
            obj.ServiceConnectedPercentage = (string.IsNullOrEmpty(GetReaderValue(reader["SERVICE_CONNECTED_PERCENTAGE"].ToString()))) ? (int?)null : int.Parse(GetReaderValue(reader["SERVICE_CONNECTED_PERCENTAGE"].ToString()));
            obj.AdmittingDiagnosis = GetReaderValue(reader["DIAGNOSIS"].ToString());
            obj.AttendingPhysician = new NewPerson();
            obj.AttendingPhysician.IEN = GetReaderValue(reader["PATIENT_ATTENDING_PHYSICIAN"].ToString());
            obj.AttendingPhysician.Name = GetReaderValue(reader["PATIENT_ATTENDING_PHYSICIAN_NAME"].ToString());
            if (string.IsNullOrEmpty(obj.AttendingPhysician.IEN))
                obj.AttendingPhysician = null;
            return obj;
        }

        private static string GetSsn(string value)
        {
            return value.Insert(3, "-") .Insert(6, "-");
        }

        private static WardLocation TranslateWard(CacheDataReader reader)
        {
            WardLocation ward = new WardLocation();
            ward.IEN = GetReaderValue(reader["WARD_IEN"].ToString());
            if (string.IsNullOrEmpty(ward.IEN))
                return null;
            ward.Name = GetReaderValue(reader["WARD_NAME"].ToString());
            ward.IsCurrentlyOutOfService = (GetReaderValue(reader["WARD_CURRENTLY_OUTOFSERVICE"].ToString()) == "1") ? true : false;
            ward.SpecialtyId = GetReaderValue(reader["WARD_SPECIALTY_IEN"].ToString());            
            ward.Specialty = new Specialty();
            ward.Specialty.IEN = GetReaderValue(reader["WARD_SPECIALTY_IEN"].ToString());
            ward.Specialty.Name = GetReaderValue(reader["WARD_SPECIALTY_NAME"].ToString());            
            if (string.IsNullOrEmpty(ward.Specialty.IEN))
                ward.Specialty = null;
            return ward;
        }

        private static WardLocation TranslateWard2(CacheDataReader reader)
        {
            WardLocation ward = new WardLocation();
            ward.IEN = GetReaderValue(reader["RB_WARD_IEN"].ToString());
            if (string.IsNullOrEmpty(ward.IEN))
                return null;
            ward.Name = GetReaderValue(reader["RB_WARD_NAME"].ToString());
            ward.IsCurrentlyOutOfService = (GetReaderValue(reader["RB_WARD_OUT_OF_SERVICE"].ToString()) == "1") ? true : false;
            ward.SpecialtyId = GetReaderValue(reader["RB_WARD_SPECIALTY_IEN"].ToString());            
            ward.Specialty = new Specialty();
            ward.Specialty.IEN = GetReaderValue(reader["RB_WARD_SPECIALTY_IEN"].ToString());
            ward.Specialty.Name = GetReaderValue(reader["RB_WARD_SPECIALTY_NAME"].ToString());            
            if (string.IsNullOrEmpty(ward.Specialty.IEN))
                ward.Specialty = null;                        
            return ward;
        }

        private static HospitalLocation TranslateHospital(CacheDataReader reader)
        {
            HospitalLocation hospitalLocation = new HospitalLocation();
            hospitalLocation.IEN = GetReaderValue(reader["HOSPITAL_LOCATION_IEN"].ToString());
            if (string.IsNullOrEmpty(hospitalLocation.IEN))
                return null;
            hospitalLocation.Name = GetReaderValue(reader["HOSPITAL_LOCATION_NAME"].ToString());
            hospitalLocation.Abbreviation = GetReaderValue(reader["HOSPITAL_LOCATION_ABBREVIATION"].ToString());
            hospitalLocation.Telephone = GetReaderValue(reader["HOSPITAL_LOCATION_TELEPHONE"].ToString());
            hospitalLocation.WardLocationId = GetReaderValue(reader["WARD_IEN"].ToString());
            hospitalLocation.WardLocation = TranslateWard(reader);
            return hospitalLocation;
        }

        private static string GetReaderValue(string value)
        {
            if (value == string.Empty)
                return null;
            return value;
        }
    }
}
