﻿using System;
using System.Xml.Serialization;
using System.Runtime.Serialization;
using InfoWorld.HL7.ITS;
using System.Collections;
using System.Collections.Generic;

namespace BMS.DataContracts
{
    /// <summary>
    /// Contains data about ScheduledAdmissions managed by BMS.
    /// </summary>
    [Serializable]
    [XmlType(TypeName = "ScheduledAdmission")]
    [DataContract(Name = "ScheduledAdmission")]    
    [KnownType(typeof(CD))]
    [KnownType(typeof(II))]
    public class ScheduledAdmission
    {
        #region Public Members

        /// <summary>
        /// Gets or sets the id. Identity number and primary key of the table.
        /// </summary>
        /// <value>
        /// The id.
        /// </value>
        [XmlElementAttribute("Id", Order = 1)]
        [DataMember(EmitDefaultValue = false, Name = "Id", Order = 1)]
        public II Id { get; set; }

        /// <summary>
        /// Gets or sets the patient id scheduled for admission.
        /// </summary>
        /// <value>
        /// The patient id.
        /// </value>
        [XmlElementAttribute("PatientId", Order = 2)]
        [DataMember(EmitDefaultValue = false, Name = "PatientId", Order = 2)]
        public II PatientId { get; set; }

        /// <summary>
        /// Gets or sets the VistA IEN.
        /// </summary>
        /// <value>
        /// The IEN.
        /// </value>
        [XmlElementAttribute("IEN", Order = 3)]
        [DataMember(EmitDefaultValue = false, Name = "IEN", Order = 3)]
        public string IEN { get; set; }

        /// <summary>
        /// Gets or sets the canceled date of the scheduled admission.
        /// </summary>
        /// <value>
        /// The canceled date.
        /// </value>
        [XmlElementAttribute("CanceledDate", Order = 4)]
        [DataMember(EmitDefaultValue = false, Name = "CanceledDate", Order = 4)]
        public DateTime? CanceledDate { get; set; }

        /// <summary>
        /// Gets or sets the reservation date of the scheduled admission.
        /// </summary>
        /// <value>
        /// The canceled date.
        /// </value>
        [XmlElementAttribute("ReservationDate", Order = 5)]
        [DataMember(EmitDefaultValue = false, Name = "ReservationDate", Order = 5)]
        public DateTime? ReservationDate { get; set; }

        /// <summary>
        /// Gets or sets the medical person in charge with the ScheduledAdmission act(EIS person reference).
        /// </summary>
        /// <value>
        /// The provider.
        /// </value>
        [XmlElementAttribute("ProviderId", Order = 6)]
        [DataMember(EmitDefaultValue = false, Name = "ProviderId", Order = 6)]
        public II ProviderId { get; set; }

        /// <summary>
        /// Gets or sets the medical person that schedules the ScheduledAdmission(EIS person).
        /// </summary>
        /// <value>
        /// The scheduler.
        /// </value>
        [XmlElementAttribute("SchedulerId", Order = 7)]
        [DataMember(EmitDefaultValue = false, Name = "SchedulerId", Order = 7)]
        public II SchedulerId { get; set; }

        /// <summary>
        /// Gets or sets the vista site where the patient will be admitted.
        /// </summary>
        /// <value>
        /// The vista site.
        /// </value>
        [XmlElementAttribute("VistaSiteId", Order = 8)]
        [DataMember(EmitDefaultValue = false, Name = "VistaSiteId", Order = 8)]
        public II VistaSiteId { get; set; }

        /// <summary>
        /// Gets or sets the ward in which the bed is located(EIS place reference).
        /// </summary>
        /// <value>
        /// The ward.
        /// </value>
        [XmlElementAttribute("WardId", Order = 9)]
        [DataMember(EmitDefaultValue = false, Name = "WardId", Order = 9)]
        public II WardId { get; set; }

        /// <summary>
        /// Gets or sets the treating speciality for a scheduled ScheduledAdmission.
        /// </summary>
        /// <value>
        /// The speciality.
        /// </value>
        [XmlElementAttribute("Speciality", Order = 10)]
        [DataMember(EmitDefaultValue = false, Name = "Speciality", Order = 10)]
        public CD Speciality { get; set; }

        /// <summary>
        /// Gets or sets the patient diagnosis.
        /// </summary>
        /// <value>
        /// The diagnosis.
        /// </value>
        [XmlElementAttribute("Diagnosis", Order = 11)]
        [DataMember(EmitDefaultValue = false, Name = "Diagnosis", Order = 11)]
        public string Diagnosis { get; set; }

        /// <summary>
        /// Gets or sets the value indicating whether the patinet needs surgery.
        /// </summary>
        /// <value>
        /// The surgery.
        /// </value>
        [XmlElementAttribute("Surgery", Order = 12)]
        [DataMember(EmitDefaultValue = false, Name = "Surgery", Order = 12)]
        public bool Surgery { get; set; }

        /// <summary>
        /// Gets or sets the length of stay expected for a scheduled ScheduledAdmission.
        /// </summary>
        /// <value>
        /// The LOS expected.
        /// </value>
        [XmlElementAttribute("LOSExpected", Order = 13)]
        [DataMember(EmitDefaultValue = false, Name = "LOSExpected", Order = 13)]
        public int LOSExpected { get; set; }

        /// <summary>
        /// Gets or sets the vista division.
        /// </summary>
        /// <value>
        /// The vista division.
        /// </value>
        [XmlElementAttribute("VistaDivision", Order = 14)]
        [DataMember(EmitDefaultValue = false, Name = "VistaDivision", Order = 14)]
        public CD VistaDivision { get; set; }

        #endregion
    }
}
